package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.bean.MultiInputBean;
import com.gingersoft.gsa.cloud.common.ui.adapter.multi.InfoMultiAdapter;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerNewFoodUnitComponent;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.contract.NewFoodUnitContract;
import com.gingersoft.supply_chain.mvp.presenter.NewFoodUnitPresenter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;
import static com.gingersoft.supply_chain.mvp.ui.fragment.MeasurementUnitFragment.EDIT_FOOD_UNIT_REQUEST_CODE;


/**
 * ================================================
 * Description: 新增計量單位
 * <p>
 * Created by MVPArmsTemplate on 11/21/2020 16:52
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NewFoodUnitFragment extends BaseSupplyChainFragment<NewFoodUnitPresenter> implements NewFoodUnitContract.View, View.OnClickListener {

    public static final String FOOD_UNIT_KEY = "measurement_unit";

    @BindView(R2.id.topbar_food_unit_info)
    QMUITopBar topbarFoodUnitInfo;
    @BindView(R2.id.btn_save_food_unit)
    QMUIAlphaButton btnSaveFoodUnit;
    @BindView(R2.id.rv_food_unit_info)
    RecyclerView rvFoodUnitInfo;

    private MeasurementUnitBean.DataBean.Unit foodUnit;
    private boolean isUpdate = false;
    private InfoMultiAdapter infoMultiAdapter;

    public static NewFoodUnitFragment newInstance(MeasurementUnitBean.DataBean.Unit unit) {
        NewFoodUnitFragment fragment = new NewFoodUnitFragment();
        if (unit != null) {
            Bundle bundle = new Bundle();
            bundle.putSerializable(FOOD_UNIT_KEY, unit);
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerNewFoodUnitComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_new_food_unit, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            foodUnit = (MeasurementUnitBean.DataBean.Unit) arguments.getSerializable(FOOD_UNIT_KEY);
        }
        initTopBar();

        List<InfoMultiBean> infoMultiBeans = new ArrayList<>();
        InfoMultiBean unitType = new InfoMultiBean(InfoMultiBean.ITEM_TYPE_SHOW_DIALOG, "單位種類", false, "請選擇");

        List<InfoMultiBean> units = new ArrayList<>();
        for (int i = 0; i < MeasurementUnitBean.DataBean.Unit.measurementUnits.size(); i++) {
            units.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_SHOW_DIALOG, MeasurementUnitBean.DataBean.Unit.measurementUnits.get(i)));
        }
        unitType.setInfoMultiBeans(units);

        infoMultiBeans.add(unitType);
        infoMultiBeans.add(new MultiInputBean(InfoMultiBean.ITEM_TYPE_INPUT, "計量單位", false, "請輸入計量單位"));
        infoMultiBeans.add(new MultiInputBean(InfoMultiBean.ITEM_TYPE_INPUT, "備註", false, "請輸入備註"));
        if(foodUnit != null){
            units.get(foodUnit.getType()).setChecked(true);
            infoMultiBeans.get(1).setShowValue(foodUnit.getUnitContent());
            infoMultiBeans.get(2).setShowValue(foodUnit.getRemarks());
        }
        infoMultiAdapter = new InfoMultiAdapter(mContext, infoMultiBeans);
        rvFoodUnitInfo.addItemDecoration(new DividerItemDecoration(mContext, VERTICAL_LIST));
        rvFoodUnitInfo.setAdapter(infoMultiAdapter);
    }

    private void initTopBar() {
        if (foodUnit != null) {
            isUpdate = true;
            topbarFoodUnitInfo.setTitle("編輯計量單位");
        } else {
            topbarFoodUnitInfo.setTitle("新增計量單位");
        }
        topbarFoodUnitInfo.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

    @OnClick({R2.id.btn_save_food_unit})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_save_food_unit) {
            //保存
            if (isUpdate) {
                mPresenter.updateFoodUnit(mPresenter.getFoodUnit(infoMultiAdapter.getData(), foodUnit));
            } else {
                mPresenter.addFoodUnit(mPresenter.getFoodUnit(infoMultiAdapter.getData(), foodUnit));
            }
        }
    }

    @Override
    public void saveSuccess() {
        setFragmentResult(EDIT_FOOD_UNIT_REQUEST_CODE, null);
        killMyself();
    }
}
