package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.common.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerNewSupplierComponent;
import com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean;
import com.gingersoft.supply_chain.mvp.content.Constant;
import com.gingersoft.supply_chain.mvp.contract.NewSupplierContract;
import com.gingersoft.supply_chain.mvp.presenter.NewSupplierPresenter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;
import static com.gingersoft.supply_chain.mvp.ui.fragment.SupplierListFragment.SUPPLIER_LIST;


/**
 * Description:新增或編輯供應商
 * @author yuhang
 */
public class NewSupplierFragment extends BaseSupplyChainFragment<NewSupplierPresenter> implements NewSupplierContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_supplier_info)
    QMUITopBar topbarSupplierInfo;
    @BindView(R2.id.rv_supplier_info)
    RecyclerView rvSupplierInfo;
    @BindView(R2.id.btn_save_supplier)
    QMUIAlphaButton btnSaveSupplier;

    private SupplierInfoBean supplierBean;
    private boolean isUpdate = false;
    private final static String SUPPLIER_INFO_KEY = "supplier_info_key";

    public static NewSupplierFragment newInstance(SupplierInfoBean supplierBean) {
        NewSupplierFragment fragment = new NewSupplierFragment();
        if (supplierBean != null) {
            Bundle bundle = new Bundle();
            bundle.putSerializable(SUPPLIER_INFO_KEY, supplierBean);
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerNewSupplierComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_new_supplier, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle arguments = getArguments();
        if (arguments != null) {
            supplierBean = (SupplierInfoBean) arguments.getSerializable(SUPPLIER_INFO_KEY);
        }
        initTopBar();
        rvSupplierInfo.addItemDecoration(new DividerItemDecoration(mContext, VERTICAL_LIST));
        rvSupplierInfo.setAdapter(mPresenter.initAdapter(mContext, supplierBean));
        if (supplierBean != null) {
            //獲取供應商聯繫方式，在設置adapter之後
            mPresenter.getSupplierContact(supplierBean.getId() + "");
        }
    }

    private void initTopBar() {
        if (supplierBean != null) {
            isUpdate = true;
            topbarSupplierInfo.addRightImageButton(R.drawable.ic_white_delete, R.id.topbar_right_delete_button).setOnClickListener(this);
            topbarSupplierInfo.setTitle("編輯供應商");
        } else {
            topbarSupplierInfo.setTitle("新增供應商");
        }
        topbarSupplierInfo.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

    @OnClick({R2.id.btn_save_supplier})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_delete_button) {
            //刪除供應商
            new AppDialog().showWaringDialog(mContext, "刪除供應商", (view1, dialog) -> {
                dialog.dismiss();
                supplierBean.setDeletes(Constant.DELETE);
                mPresenter.updateSupplier();
            });
        } else if (viewId == R.id.btn_save_supplier) {
            //保存
            if (isUpdate) {
                mPresenter.updateSupplier();
            } else {
                mPresenter.addSupplier();
            }
        }
    }

    @Override
    public void saveSuccess() {
        setFragmentResult(SUPPLIER_LIST, null);
        killMyself();
    }
}
