package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.ui.adapter.RadioListAdapter;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerSendMsgComponent;
import com.gingersoft.supply_chain.mvp.bean.ConfirmOrderBean;
import com.gingersoft.supply_chain.mvp.contract.SendMsgContract;
import com.gingersoft.supply_chain.mvp.presenter.SendMsgPresenter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean.SupplierContacts.Efax;
import static com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean.SupplierContacts.Email;
import static com.gingersoft.supply_chain.mvp.bean.SupplierInfoBean.SupplierContacts.SMS;


/**
 * Description: 發送消息到供應商
 */
public class SendMsgFragment extends BaseSupplyChainFragment<SendMsgPresenter> implements SendMsgContract.View {


    private final static String KEY_PURCHASE_ORDER_INFO = "purchaseOrders";
    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.rv_send_select_supplier)
    RecyclerView rvSupplier;
    @BindView(R2.id.cb_email)
    CheckBox cbEmail;
    @BindView(R2.id.cb_sms)
    CheckBox cbSms;
    @BindView(R2.id.cb_efax)
    CheckBox cbEfax;
    @BindView(R2.id.rb_whatsapp)
    RadioButton rbWhatsapp;
    @BindView(R2.id.rb_wechat)
    RadioButton rbWechat;
    @BindView(R2.id.rb_line)
    RadioButton rbLine;
    @BindView(R2.id.rb_kakao)
    RadioButton rbKakao;
    @BindView(R2.id.rg_send_msg_method)
    RadioGroup rgSendMsgMethod;
    @BindView(R2.id.layout_contact_information)
    LinearLayout layoutContactInformation;
    @BindView(R2.id.horizontal_dotted)
    View horizontalDotted;
    @BindView(R2.id.cb_has_qrcode)
    CheckBox cbHasQrCode;
    @BindView(R2.id.iv_msg_qr_code)
    ImageView ivQrCode;
    @BindView(R2.id.btn_supplier_confirm)
    QMUIAlphaButton btnSupplierConfirm;
    @BindView(R2.id.btn_supplier_cancel)
    QMUIAlphaButton btnSupplierCancel;
    private List<ConfirmOrderBean.PurchaseOrder> purchaseOrders;

    private RadioListAdapter radioListAdapter;

    public static SendMsgFragment newInstance(List<ConfirmOrderBean.PurchaseOrder> purchaseOrders) {
        SendMsgFragment fragment = new SendMsgFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(KEY_PURCHASE_ORDER_INFO, (Serializable) purchaseOrders);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerSendMsgComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_send_msg, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar(supplyTopBar, "發送");
        Bundle arguments = getArguments();
        if (arguments != null) {
            purchaseOrders = (List<ConfirmOrderBean.PurchaseOrder>) arguments.getSerializable(KEY_PURCHASE_ORDER_INFO);
        }
        if (purchaseOrders != null && purchaseOrders.size() > 0) {
            List<String> supplierNames = new ArrayList<>();
            for (ConfirmOrderBean.PurchaseOrder purchaseOrder : purchaseOrders) {
                supplierNames.add(purchaseOrder.getSupplierName());
            }
            radioListAdapter = new RadioListAdapter(R.layout.item_radio_left, supplierNames);
            radioListAdapter.setSelectIndex(0);
            mPresenter.getPurchaseOrderQrCode(purchaseOrders.get(radioListAdapter.getSelectIndex()).getId() + "");
            rvSupplier.setLayoutManager(new GridLayoutManager(mContext, 2));
            rvSupplier.setAdapter(radioListAdapter);
            radioListAdapter.setOnItemClickListener((adapter, view, position) -> {
                //切換供應商
                //選擇默認的聯繫方式
                //獲取信息鏈接
                mPresenter.getPurchaseOrderQrCode(purchaseOrders.get(position).getId() + "");
                radioListAdapter.setSelectIndex(position);
            });
        } else {
            killMyself();
        }
    }

    @OnClick({R2.id.btn_supplier_confirm, R2.id.btn_supplier_cancel})
    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.btn_supplier_confirm) {
            //發送
            if (rgSendMsgMethod.getCheckedRadioButtonId() == R.id.rb_whatsapp) {
                //分享到WhatsApp
                DeviceUtils.shareWhatsApp(mContext, url);
            } else if (rgSendMsgMethod.getCheckedRadioButtonId() == R.id.rb_wechat) {
                //分享到微信
                DeviceUtils.shareWeChatFriend(mContext, url);
            } else if (rgSendMsgMethod.getCheckedRadioButtonId() == R.id.rb_line) {
                //分享到Line
                DeviceUtils.shareLine(mContext, "", url);
            } else if (rgSendMsgMethod.getCheckedRadioButtonId() == R.id.rb_kakao) {
                //跳轉Kakao

            }
            if (cbEmail.isChecked()) {
                //發送email
                sendMsg(Email);
            }
            if (cbSms.isChecked()) {
                //發送SMS
                sendMsg(SMS);
            }
            if (cbEfax.isChecked()) {
                //發送Efax
                sendMsg(Efax);
            }

        } else if (viewId == R.id.btn_supplier_cancel) {
            popTo(PurchaseListFragment.class, true);
        }
    }

    private void sendMsg(int email) {
        mPresenter.sendMsg(purchaseOrders.get(radioListAdapter.getSelectIndex()).getId(), email);
    }

    private String url;

    @Override
    public void loadQrCode(String url) {
        this.url = url;
        com.gingersoft.gsa.cloud.base.utils.glide.GlideUtils.display(mContext, ivQrCode, url);
    }
}
