package com.gingersoft.gsa.cloud.bean;

import android.text.InputFilter;

import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;

import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 14:15
 * Use: 多類型輸入
 */
@Data
public class MultiInputBean extends InfoMultiBean {

    private InputFilter[] inputFilters;
    private int inputType = -1;
    private int maxLength = 0;

    private MultiInputBean() {
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        super(itemType, showTitle, isRequired, hintText);
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputType = type;
    }
    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue) {
        super(itemType, showTitle, isRequired, hintText, showValue);
    }
    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
        this.inputType = type;
    }

    public MultiInputBean(int itemType, String showTitle, String hintText, String hintTextSecond, String hintTextThird, ISupportFragment supportFragment) {
        super(itemType, showTitle, hintText, hintTextSecond, hintTextThird, supportFragment);
    }
}
