package com.gingersoft.gsa.cloud.common.core.order.billItem;

import android.graphics.Color;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-10-14
 * @update date: 2020-10-14
 * @description: 賬單項抽象類{@link BillItem}
 */
@Data
public abstract class BillItem {

    protected String name;
    protected double money = 0.0;
    protected int textSize;
    protected int textColor = Color.parseColor("#000000");
    protected int bgColor;

    /**是否已送單#0=未送單;1=已送單*/
    protected int status = 0;
    public static final byte BILL_ITEM_NO_ORDER_STATUS = 0;
    public static final byte BILL_ITEM_ORDER_SENT_STATUS = 1;

    public byte type = NOMAL_DISCOUNT_TYPE;
    /**整單折扣*/
    public static final byte NOMAL_DISCOUNT_TYPE = 0;
    /**會員等級折扣*/
    public static final byte MEMBER_DISCOUNT_TYPE = 1;
    /**優惠券折扣*/
    public static final byte COUPON_DISCOUNT_TYPE = 2;
    /**服務費*/
    public static final byte SERVERCHARGE_TYPE = 3;
    /**賬單小數*/
    public static final byte ROUNDING_TYPE = 4;


    public BillItem() {
    }

    public BillItem(String name) {
        this.name = name;
    }

    public BillItem(byte type, String name) {
        this.type = type;
        this.name = name;
    }

    public BillItem(String name, int status) {
        this.name = name;
        this.status = status;
    }

    public BillItem(String name, double money, int status) {
        this.name = name;
        this.money = money;
        this.status = status;
    }

    public BillItem(String name, double money, int status, byte type) {
        this.name = name;
        this.money = money;
        this.status = status;
        this.type = type;
    }
}
