package com.gingersoft.gsa.cloud.common.core.pay;

import android.graphics.Color;
import android.text.TextUtils;

import com.google.gson.annotations.SerializedName;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-15
 * 修订历史：2020-02-15
 * 描述：
 */
@Data
public class PayMethod {

    /**
     * id : 12
     * brandId : 1
     * restaurantId : 26
     * nameFirst : 兒不同
     * nameSecond : 吃v否
     * nameThird : 份日日法人
     * whetherSales : 1
     * whetherManagerAuthority : 0
     * color : #00FF2F
     * whetherReportCount : 1
     * interactiveType : 1
     * whetherFixedAmount : 1
     * payType : 8
     * minPayAmount : 0
     * whetherFreeService : 1
     * whetherTaxExemption : 1
     * whetherSignatureLine : 1
     * paySeq : 1
     * whetherOpenBox : 1
     * getIntegral : 5
     * integralMultiple : 2
     * deductionIntegral : 1
     * dockingType : 0
     * billType : 1,2
     * tablePrintingAmount : 2
     * takeOutPrintingAmount : 2
     * updateTime : 1598674202856
     * createTime : 1598674202856
     * updateUid : 492
     * createUid : 492
     */

    private int id;
    private int brandId;
    private int restaurantId;
    private String nameFirst;
    private String nameSecond;
    private String nameThird;
    /**
     * 銷售營業額(0:非營業額 1：營業額)
     */
    private int whetherSales;
    /**
     * 經理權限
     */
    private int whetherManagerAuthority;
    /**
     * 背景顔色
     */
    private String color = "#FFFFFF";
    /**
     * 字體顔色
     */
    private String font_color = "#000000";
    /**
     * 報表計算人數(0:否 1：是)
     */
    private int whetherReportCount;
    /**
     * 交互方式
     */
    private int interactiveType;
    /**
     * 固定金額 (0:否 1：是)
     */
    private int whetherFixedAmount;
    /**
     * 固定金額數值
     */
    private double amountValue;
    /**
     * 支付方式(1:寶達通 8:支付寶 1001:現金 1023:支付寶HK
     * )
     */
    private int payType;
    /**
     * 最小支付金額（是否有小數點）
     */
    private double minPayAmount;
    /**
     * 是否免服務費(0:否 1：是)
     */
    private int whetherFreeService;
    /**
     * 是否免稅  (0:否 1：是)
     */
    private int whetherTaxExemption;
    /**
     * 是否展示簽署線 (0:否 1：是)
     */
    private int whetherSignatureLine;
    /**
     * 排序
     */
    private int paySeq;
    /**
     * 是否開錢箱(0:否 1：是)
     */
    private int whetherOpenBox;
    /**
     * '獲取積分
     */
    private int getIntegral;
    /**
     * 積分倍數
     */
    private int integralMultiple;
    /**
     * 扣減積分
     */
    private float deductionIntegral;
    /**
     * 對接類型 (0:否 1:yedpay 2:八達通 3:積分 )
     */
    private int dockingType;
    /**
     * 賬單類型(0:否 1：是)
     */
    private String billType;
    /**
     * 櫃檯結賬打印
     */
    private int tablePrintingAmount;
    /**
     * 外賣結賬打印
     */
    private int takeOutPrintingAmount;
    private long updateTime;
    @SerializedName("createTime")
    private long createTimeX;
    private int updateUid;
    private int createUid;


    //*************自定義字段***************
    private double payMoney = 0.0;
    private double TipsPrice = 0.0;
    private int payModeTextColor = Color.parseColor("#000000");
    private int payMoneyTextColor = Color.parseColor("#000000");
    private int payModeTextSelectColor = Color.parseColor("#000000");
    private int payMoneyTextSelectColor = Color.parseColor("#000000");
    private int payModeSize = 14;
    private int payMoneySize = 14;


    public static final int PAY_TYPE_CASH = 1001;
    public static final int PAY_TYPE_INTEGRAL = 2000;

    public PayMethod() {
    }

    public PayMethod(int id, String nameFirst, String nameSecond, String nameThird) {
        this.id = id;
        this.nameFirst = nameFirst;
        this.nameSecond = nameSecond;
        this.nameThird = nameThird;
    }

    public PayMethod(PayMethod method) {
        this.id = method.id;
        this.brandId = method.brandId;
        this.restaurantId = method.restaurantId;
        this.nameFirst = method.nameFirst;
        this.nameSecond = method.nameSecond;
        this.nameThird = method.nameThird;
        this.whetherSales = method.whetherSales;
        this.whetherManagerAuthority = method.whetherManagerAuthority;
        this.color = method.color;
        this.font_color = method.font_color;
        this.whetherReportCount = method.whetherReportCount;
        this.interactiveType = method.interactiveType;
        this.whetherFixedAmount = method.whetherFixedAmount;
        this.amountValue = method.amountValue;
        this.payType = method.payType;
        this.minPayAmount = method.minPayAmount;
        this.whetherFreeService =method. whetherFreeService;
        this.whetherTaxExemption = method.whetherTaxExemption;
        this.whetherSignatureLine =method. whetherSignatureLine;
        this.paySeq = method.paySeq;
        this.whetherOpenBox = method.whetherOpenBox;
        this.getIntegral = method.getIntegral;
        this.integralMultiple =method. integralMultiple;
        this.deductionIntegral =method. deductionIntegral;
        this.dockingType =method. dockingType;
        this.billType = method.billType;
        this.tablePrintingAmount = method.tablePrintingAmount;
        this.takeOutPrintingAmount =method. takeOutPrintingAmount;
        this.updateTime = method.updateTime;
        this.createTimeX = method.createTimeX;
        this.updateUid = method.updateUid;
        this.createUid = method.createUid;
        this.payMoney =method. payMoney;
        this. TipsPrice = method.TipsPrice;
        this.payModeTextColor = method.payModeTextColor;
        this.payMoneyTextColor =method. payMoneyTextColor;
        this.payModeTextSelectColor =method. payModeTextSelectColor;
        this.payMoneyTextSelectColor =method. payMoneyTextSelectColor;
        this.payModeSize =method. payModeSize;
        this.payMoneySize =method. payMoneySize;
    }

    public String getPayName() {
        if (!TextUtils.isEmpty(nameFirst))
            return nameFirst;
        if (!TextUtils.isEmpty(nameSecond))
            return nameSecond;
        if (!TextUtils.isEmpty(nameThird))
            return nameThird;
        return "";
    }

    public void setPayName(String name){
        this.nameFirst = name;
        this.nameSecond = name;
        this.nameThird = name;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getBrandId() {
        return brandId;
    }

    public void setBrandId(int brandId) {
        this.brandId = brandId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public String getNameFirst() {
        return nameFirst;
    }

    public void setNameFirst(String nameFirst) {
        this.nameFirst = nameFirst;
    }

    public String getNameSecond() {
        return nameSecond;
    }

    public void setNameSecond(String nameSecond) {
        this.nameSecond = nameSecond;
    }

    public String getNameThird() {
        return nameThird;
    }

    public void setNameThird(String nameThird) {
        this.nameThird = nameThird;
    }

    public int getWhetherSales() {
        return whetherSales;
    }

    public void setWhetherSales(int whetherSales) {
        this.whetherSales = whetherSales;
    }

    public int getWhetherManagerAuthority() {
        return whetherManagerAuthority;
    }

    public void setWhetherManagerAuthority(int whetherManagerAuthority) {
        this.whetherManagerAuthority = whetherManagerAuthority;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getFont_color() {
        return font_color;
    }

    public void setFont_color(String font_color) {
        this.font_color = font_color;
    }

    public int getWhetherReportCount() {
        return whetherReportCount;
    }

    public void setWhetherReportCount(int whetherReportCount) {
        this.whetherReportCount = whetherReportCount;
    }

    public int getInteractiveType() {
        return interactiveType;
    }

    public void setInteractiveType(int interactiveType) {
        this.interactiveType = interactiveType;
    }

    public int getWhetherFixedAmount() {
        return whetherFixedAmount;
    }

    public void setWhetherFixedAmount(int whetherFixedAmount) {
        this.whetherFixedAmount = whetherFixedAmount;
    }

    public double getAmountValue() {
        return amountValue;
    }

    public void setAmountValue(double amountValue) {
        this.amountValue = amountValue;
    }

    public int getPayType() {
        return payType;
    }

    public void setPayType(int payType) {
        this.payType = payType;
    }

    public double getMinPayAmount() {
        return minPayAmount;
    }

    public void setMinPayAmount(double minPayAmount) {
        this.minPayAmount = minPayAmount;
    }

    public int getWhetherFreeService() {
        return whetherFreeService;
    }

    public void setWhetherFreeService(int whetherFreeService) {
        this.whetherFreeService = whetherFreeService;
    }

    public int getWhetherTaxExemption() {
        return whetherTaxExemption;
    }

    public void setWhetherTaxExemption(int whetherTaxExemption) {
        this.whetherTaxExemption = whetherTaxExemption;
    }

    public int getWhetherSignatureLine() {
        return whetherSignatureLine;
    }

    public void setWhetherSignatureLine(int whetherSignatureLine) {
        this.whetherSignatureLine = whetherSignatureLine;
    }

    public int getPaySeq() {
        return paySeq;
    }

    public void setPaySeq(int paySeq) {
        this.paySeq = paySeq;
    }

    public int getWhetherOpenBox() {
        return whetherOpenBox;
    }

    public void setWhetherOpenBox(int whetherOpenBox) {
        this.whetherOpenBox = whetherOpenBox;
    }

    public int getGetIntegral() {
        return getIntegral;
    }

    public void setGetIntegral(int getIntegral) {
        this.getIntegral = getIntegral;
    }

    public int getIntegralMultiple() {
        return integralMultiple;
    }

    public void setIntegralMultiple(int integralMultiple) {
        this.integralMultiple = integralMultiple;
    }

    public float getDeductionIntegral() {
        return deductionIntegral;
    }

    public void setDeductionIntegral(float deductionIntegral) {
        this.deductionIntegral = deductionIntegral;
    }

    public int getDockingType() {
        return dockingType;
    }

    public void setDockingType(int dockingType) {
        this.dockingType = dockingType;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public int getTablePrintingAmount() {
        return tablePrintingAmount;
    }

    public void setTablePrintingAmount(int tablePrintingAmount) {
        this.tablePrintingAmount = tablePrintingAmount;
    }

    public int getTakeOutPrintingAmount() {
        return takeOutPrintingAmount;
    }

    public void setTakeOutPrintingAmount(int takeOutPrintingAmount) {
        this.takeOutPrintingAmount = takeOutPrintingAmount;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getCreateTimeX() {
        return createTimeX;
    }

    public void setCreateTimeX(long createTimeX) {
        this.createTimeX = createTimeX;
    }

    public int getUpdateUid() {
        return updateUid;
    }

    public void setUpdateUid(int updateUid) {
        this.updateUid = updateUid;
    }

    public int getCreateUid() {
        return createUid;
    }

    public void setCreateUid(int createUid) {
        this.createUid = createUid;
    }

    public double getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(double payMoney) {
        this.payMoney = payMoney;
    }

    public double getTipsPrice() {
        return TipsPrice;
    }

    public void setTipsPrice(double tipsPrice) {
        TipsPrice = tipsPrice;
    }

    public int getPayModeTextColor() {
        return payModeTextColor;
    }

    public void setPayModeTextColor(int payModeTextColor) {
        this.payModeTextColor = payModeTextColor;
    }

    public int getPayMoneyTextColor() {
        return payMoneyTextColor;
    }

    public void setPayMoneyTextColor(int payMoneyTextColor) {
        this.payMoneyTextColor = payMoneyTextColor;
    }

    public int getPayModeTextSelectColor() {
        return payModeTextSelectColor;
    }

    public void setPayModeTextSelectColor(int payModeTextSelectColor) {
        this.payModeTextSelectColor = payModeTextSelectColor;
    }

    public int getPayMoneyTextSelectColor() {
        return payMoneyTextSelectColor;
    }

    public void setPayMoneyTextSelectColor(int payMoneyTextSelectColor) {
        this.payMoneyTextSelectColor = payMoneyTextSelectColor;
    }

    public int getPayModeSize() {
        return payModeSize;
    }

    public void setPayModeSize(int payModeSize) {
        this.payModeSize = payModeSize;
    }

    public int getPayMoneySize() {
        return payMoneySize;
    }

    public void setPayMoneySize(int payMoneySize) {
        this.payMoneySize = payMoneySize;
    }

    public static int getPayTypeCash() {
        return PAY_TYPE_CASH;
    }

    public static int getPayTypeIntegral() {
        return PAY_TYPE_INTEGRAL;
    }
}
