package com.gingersoft.gsa.cloud.common.core.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.common.core.print.bean.base.PrintPayTypeItem;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-01
 * @update date: 2020-12-01
 * @description:外賣結賬打印實體
 */
@Data
public class PrintTakeawayCheckoutContent extends PrintTakeawayFormContent implements Parcelable ,PrintContent {

    /**
     * 支付方式
     */
    private List<PrintPayTypeItem> payTypeList;

    public PrintTakeawayCheckoutContent() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.payTypeList);
    }

    protected PrintTakeawayCheckoutContent(Parcel in) {
        super(in);
        this.payTypeList = in.createTypedArrayList(PrintPayTypeItem.CREATOR);
    }

    public static final Creator<PrintTakeawayCheckoutContent> CREATOR = new Creator<PrintTakeawayCheckoutContent>() {
        @Override
        public PrintTakeawayCheckoutContent createFromParcel(Parcel source) {
            return new PrintTakeawayCheckoutContent(source);
        }

        @Override
        public PrintTakeawayCheckoutContent[] newArray(int size) {
            return new PrintTakeawayCheckoutContent[size];
        }
    };
}
