package com.gingersoft.gsa.cloud.common.ui.adapter;

import android.widget.RadioButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/21
 * Time: 17:41
 * Use:
 */
public class RadioListAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private int selectIndex = 0;

    public RadioListAdapter(@Nullable List<String> data) {
        super(R.layout.item_radio, data);
    }

    public RadioListAdapter(int layoutId, @Nullable List<String> data) {
        super(layoutId, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, String s) {
        RadioButton radioButton = viewHolder.getView(R.id.rb_select_dialog_list_radio);
        radioButton.setChecked(viewHolder.getAdapterPosition() == selectIndex);
        viewHolder.setText(R.id.tv_select_dialog_list_title, s);
        radioButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                setSelectIndex(viewHolder.getAdapterPosition());
            }
        });
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return selectIndex;
    }
}
