package com.gingersoft.gsa.cloud.common.ui.adapter.multi;

import android.content.Context;

import com.chad.library.adapter.base.BaseProviderMultiAdapter;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.multi.MultiUploadPicProvider;
import com.gingersoft.gsa.cloud.ui.adapter.multi.MultipleInputProvider;
import com.gingersoft.gsa.cloud.ui.adapter.multi.RemarkProvider;
import com.gingersoft.gsa.cloud.ui.adapter.multi.SelectItemProvider;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 10:40
 * Use:
 */
public class InfoMultiAdapter extends BaseProviderMultiAdapter<InfoMultiBean> {

    @Override
    protected int getItemType(@NotNull List<? extends InfoMultiBean> list, int i) {
        return list.get(i).getItemType();
    }

    public InfoMultiAdapter(Context context, List<InfoMultiBean> infoMultiBeans) {
        super(infoMultiBeans);
        addItemProvider(new InputProvider<>());
        addItemProvider(new RemarkProvider<>());
        addItemProvider(new ThickLineProvider<>());
        addItemProvider(new TitleProvider<>());
        addItemProvider(new RadioProvider<>(context));
        addItemProvider(new SelectDialogProvider<>(context));
        addItemProvider(new MultiUploadPicProvider<>(context));
        addItemProvider(new SelectItemProvider<>(context));
        addItemProvider(new MultipleInputProvider<>(context));
        addChildClickViewIds(R.id.iv_multi_upload_pic);
    }


}
