package com.gingersoft.gsa.cloud.common.utils.other;

import android.widget.EditText;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/7/5
 * 修订历史：2018/7/5
 * 描述：
 */

public class TextUtil {

    public static boolean isEmptyOrNullOrUndefined(String str) {
        return str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined");
    }

    public static boolean isEmptyOrNullOrUndefined(EditText editText) {
        if (editText == null || editText.getText() == null) {
            return true;
        } else {
            return isEmptyOrNullOrUndefined(editText.getText().toString());
        }
    }

    public static boolean isNotEmptyOrNullOrUndefined(String str) {
        return str != null && str.length() != 0 &&
                !str.equals("null") && !str.equals("undefined");
    }

    public static boolean isNotEmptyOrNullOrUndefined(EditText editText) {
        if (editText != null && editText.getText() != null) {
            String str = editText.getText().toString();
            return str.length() != 0 && !str.equals("null") && !str.equals("undefined");
        } else {
            return false;
        }
    }

    public static String isEmptyReturnString(String str) {
        if (str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined")) {
            return "";
        } else {
            return str;
        }
    }

    public static int isEmptyReturnInt(Integer str) {
        if (str == null) {
            return 0;
        } else {
            return str;
        }
    }

    /**
     * 半角转换为全角
     *
     * @param input
     * @return
     */
    public static String ToDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (c[i] == 12288) {
                c[i] = (char) 32;
                continue;
            }
            if (c[i] > 65280 && c[i] < 65375) {
                c[i] = (char) (c[i] - 65248);
            }
        }
        return new String(c);
    }

    /**
     * 去除特殊字符或将所有中文标号替换为英文标号
     *
     * @param str
     * @return
     */
    public static String stringFilter(String str) {
        // 替换中文标号
        str = str.replaceAll("【", "[").replaceAll("】", "]")
                .replaceAll("！", "!").replaceAll("：", ":");
        // 清除掉特殊字符
        String regEx = "[『』]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }


    /**
     * 判断是否中文
     * GENERAL_PUNCTUATION 判断中文的“号
     * CJK_SYMBOLS_AND_PUNCTUATION 判断中文的。号
     * HALFWIDTH_AND_FULLWIDTH_FORMS 判断中文的，号
     *
     * @param c 字符
     * @return 是否中文
     */
    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
                || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    /**
     * @return 獲取字符串長度，區分中英文
     */
    public static int getStringLength(String str) {
        if (isEmptyOrNullOrUndefined(str)) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < str.length(); i++) {
            length += isChinese(str.charAt(i)) ? 2 : 1;
        }
        return length;
    }
}
