package com.joe.print.mvp.print.maker;

import android.graphics.Bitmap;

import com.gingersoft.gsa.cloud.common.core.print.PrintDataMaker;
import com.gingersoft.gsa.cloud.common.core.print.PrinterWriter;
import com.gingersoft.gsa.cloud.common.core.print.PrinterWriterExecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by Wyh on 2020/1/9.
 * ip打印類
 */
public class PrjPrintMaker implements PrintDataMaker {

    private Map<String, Bitmap> bitmapMap;

    public PrjPrintMaker(Map<String, Bitmap> bitmapMap) {
        this.bitmapMap = bitmapMap;
    }

    @Override
    public List<byte[]> getPrintData() {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer = new PrinterWriterExecutor(255, 380);
            for (Map.Entry<String, Bitmap> bitmapMap : bitmapMap.entrySet()) {
                ArrayList<byte[]> image1 = printer.getImageByte(bitmapMap.getValue());
                data.addAll(image1);
            }
            printer.printLineFeed(5);
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndReset());
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    @Override
    public String getPrjIds() {
        for (Map.Entry<String, Bitmap> bitmapMap : bitmapMap.entrySet()) {
            return bitmapMap.getKey();
        }
        return "";
    }
}
