package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.ConfirmOrderModule;
import com.gingersoft.supply_chain.mvp.contract.ConfirmOrderContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.ConfirmOrderFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/17/2020 10:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = ConfirmOrderModule.class, dependencies = AppComponent.class)
public interface ConfirmOrderComponent {
    void inject(ConfirmOrderFragment fragment);
    @Component.Builder
    interface Builder {
        @BindsInstance
        ConfirmOrderComponent.Builder view(ConfirmOrderContract.View view);
        ConfirmOrderComponent.Builder appComponent(AppComponent appComponent);
        ConfirmOrderComponent build();
    }
}