package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerOrderContentComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodListVosBean;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.contract.OrderContentContract;
import com.gingersoft.supply_chain.mvp.presenter.OrderContentPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.ShoppingCartAdapter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.gingersoft.supply_chain.mvp.ui.fragment.FoodIngredientsFragment.ADD_ORDER;


/**
 * ================================================
 * Description: 購物車
 * 本次下單所有食品展示頁
 */
public class OrderContentFragment extends BaseSupplyChainFragment<OrderContentPresenter> implements OrderContentContract.View, View.OnClickListener {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar topBar;
    @BindView(R2.id.rv_order_content)
    RecyclerView rvOrderContent;
    @BindView(R2.id.cb_order_content_all_select)
    CheckBox cbOrderContentAllSelect;
    @BindView(R2.id.tv_order_content_food_type_total)
    TextView tvOrderContentFoodTypeTotal;
    @BindView(R2.id.tv_order_content_total_amount)
    TextView tvOrderContentTotalAmount;
    @BindView(R2.id.ed_order_content_remark)
    EditText edOrderContentRemark;

    private ShoppingCartAdapter shoppingCartAdapter;

    public static OrderContentFragment newInstance() {
        OrderContentFragment fragment = new OrderContentFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerOrderContentComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_order_content, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar(topBar, "採購單");
        mPresenter.organizeShopCartData();
        cbOrderContentAllSelect.setOnCheckedChangeListener((buttonView, isChecked) -> {
            //全選
            if (buttonView.isPressed()) {
                if (shoppingCartAdapter != null) {
                    double totalAmount = 0;
                    int totalTypeFood = 0;
                    for (List<PurchaseFoodListVosBean> datum : shoppingCartAdapter.getData()) {
                        for (PurchaseFoodListVosBean purchaseFoodListVosBean : datum) {
                            purchaseFoodListVosBean.setChecked(isChecked);
                            if (isChecked) {
                                totalTypeFood++;
                                totalAmount = MoneyUtil.sum(totalAmount, MoneyUtil.priceCalculation(purchaseFoodListVosBean.getUnitPrice(), purchaseFoodListVosBean.getFoodCount()));
                            }
                        }
                    }
                    shoppingCartAdapter.addChecked(shoppingCartAdapter.getData());
                    setTotalInfo(totalTypeFood, totalAmount);
                    shoppingCartAdapter.notifyDataSetChanged();
                }
            }
        });
    }

    @OnClick({R2.id.btn_order_content_order_template, R2.id.btn_order_content_add_food, R2.id.tv_order_content_complete})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tv_order_content_complete) {
            //完成
            List<PurchaseFoodListVosBean> purchaseFoodListVosBeans = shoppingCartAdapter.getPurchaseFoodListVosBeans();
            //去到訂單確認頁面
            boolean isHasChecked = false;
            for (PurchaseFoodListVosBean purchaseFoodListVosBean : purchaseFoodListVosBeans) {
                if (purchaseFoodListVosBean.isChecked()) {
                    isHasChecked = true;
                    break;
                }
            }
            if (isHasChecked) {
                start(ConfirmOrderFragment.newInstance());
            } else {
                showMessage("請選擇食品");
            }
        } else if (viewId == R.id.btn_order_content_order_template) {
            //訂單模板

        } else if (viewId == R.id.btn_order_content_add_food) {
            //添加食材
            startWithPop(FoodIngredientsFragment.newInstance(ADD_ORDER));
        }
    }

    @Override
    public void loadAdapter(List<List<PurchaseFoodListVosBean>> supplierFoods) {
        shoppingCartAdapter = new ShoppingCartAdapter(mContext, supplierFoods);
        shoppingCartAdapter.setOnFoodDeleteListener((supplierIndex, foodListVosBean) -> {
            SupplyShoppingCart.getInstance().getCartFoods().remove(foodListVosBean);
            List<PurchaseFoodListVosBean> purchaseFoodListVosBeans = shoppingCartAdapter.getData().get(supplierIndex);
            purchaseFoodListVosBeans.remove(foodListVosBean);
            if (purchaseFoodListVosBeans.size() <= 0) {
                shoppingCartAdapter.getData().remove(purchaseFoodListVosBeans);
            }
            shoppingCartAdapter.notifyItemChanged(supplierIndex);
        });
        rvOrderContent.setAdapter(shoppingCartAdapter);
        shoppingCartAdapter.setOnInfoChangeListener(() -> mPresenter.calculateTotalPrice(cbOrderContentAllSelect));
    }

    @Override
    public void setTotalInfo(int typeTotal, double totalPrice) {
        tvOrderContentFoodTypeTotal.setText(String.valueOf(typeTotal));
        tvOrderContentTotalAmount.setText("$" + totalPrice);
    }
}
