package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.bean.MultiInputSelectBean;
import com.gingersoft.gsa.cloud.common.ui.adapter.multi.InfoMultiAdapter;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerPackageSpecificationComponent;
import com.gingersoft.supply_chain.mvp.bean.FoodPackingSpecificationBean;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.contract.PackageSpecificationContract;
import com.gingersoft.supply_chain.mvp.presenter.PackageSpecificationPresenter;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.io.Serializable;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;
import me.yokeyword.fragmentation.ISupportFragment;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;
import static com.gingersoft.supply_chain.mvp.ui.fragment.MeasurementUnitFragment.SELECT_FOOD_UNIT_REQUEST_CODE;
import static com.gingersoft.supply_chain.mvp.ui.fragment.MeasurementUnitFragment.SELECT_FOOD_UNIT_RESULT_DATA;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/24/2020 18:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class PackageSpecificationFragment extends BaseSupplyChainFragment<PackageSpecificationPresenter> implements PackageSpecificationContract.View, View.OnClickListener {
    /**
     * 選擇包裝規格REQUEST
     */
    public final static int SELECT_PACKAGE_SPECIFICATION_REQUEST_CODE = 1040;
    /**
     * 選擇包裝規格RESULT
     */
    public final static int SELECT_PACKAGE_SPECIFICATION_RESULT_CODE = 1041;
    @BindView(R2.id.topbar_new_package_specification)
    QMUITopBar topbarNewPackageSpecification;
    @BindView(R2.id.rv_new_package_specification)
    RecyclerView rvNewPackageSpecification;
    /**
     * 選擇訂貨單位和收貨單位的requestCode
     */
    public static final int OrderingUnitRequestCode = 1042;
    public static final int ReceivingUnitRequestCode = 1043;

    public static final String FOOD_PACKING_SPECIFICATION_DATA_KEY = "FoodPackingSpecifications";
    private InfoMultiAdapter infoMultiAdapter;

    public static PackageSpecificationFragment newInstance() {
        PackageSpecificationFragment fragment = new PackageSpecificationFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerPackageSpecificationComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_package_specification, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar();
        infoMultiAdapter = new InfoMultiAdapter(mContext, mPresenter.getInfoMultiList());
        infoMultiAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (adapter.getItemViewType(position) == InfoMultiBean.ITEM_MULTIPLE_INPUT_SELECT) {
                List<InfoMultiBean> data = infoMultiAdapter.getData();
                MultiInputSelectBean multiInputSelectBean = (MultiInputSelectBean) data.get(position);
                ISupportFragment fragment = multiInputSelectBean.getFragment();
                startForResult(fragment, multiInputSelectBean.getRequestCode());
            }
        });
        rvNewPackageSpecification.addItemDecoration(new DividerItemDecoration(mContext, VERTICAL_LIST));
        rvNewPackageSpecification.setAdapter(infoMultiAdapter);
    }

    private void initTopBar() {
        initTopBar(topbarNewPackageSpecification, "包裝規格");
    }

    @OnClick({R2.id.btn_save_new_package_specification})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_save_new_package_specification) {
            //保存包裝規格
            if (mPresenter.orderingUnit == null) {
                ToastUtils.show(mContext, "請選擇訂貨單位");
                return;
            } else if (mPresenter.receivingUnit == null) {
                ToastUtils.show(mContext, "請選擇收貨單位");
                return;
            }
            List<InfoMultiBean> data = infoMultiAdapter.getData();
            if (TextUtil.isEmptyOrNullOrUndefined(mPresenter.getOrderingMinNum(data))) {
                ToastUtils.show(mContext, "請輸入訂貨單位最小數量");
                return;
            } else if (TextUtil.isEmptyOrNullOrUndefined(mPresenter.getOrderingMaxNum(data))) {
                ToastUtils.show(mContext, "請輸入訂貨單位最大數量");
                return;
            } else if (TextUtil.isEmptyOrNullOrUndefined(mPresenter.getReceivingMinNum(data))) {
                ToastUtils.show(mContext, "請輸入收貨單位最小數量");
                return;
            } else if (TextUtil.isEmptyOrNullOrUndefined(mPresenter.getReceivingMinNum(data))) {
                ToastUtils.show(mContext, "請輸入收貨單位最大數量");
                return;
            }
            List<FoodPackingSpecificationBean> foodPackingSpecifications = mPresenter.getFoodPackingSpecifications(data);
            Bundle bundle = new Bundle();
            bundle.putSerializable(FOOD_PACKING_SPECIFICATION_DATA_KEY, (Serializable) foodPackingSpecifications);
            setFragmentResult(SELECT_PACKAGE_SPECIFICATION_RESULT_CODE, bundle);
            killMyself();
        }
    }

    @Override
    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (resultCode == SELECT_FOOD_UNIT_REQUEST_CODE) {
            MeasurementUnitBean.DataBean.Unit unit = (MeasurementUnitBean.DataBean.Unit) data.get(SELECT_FOOD_UNIT_RESULT_DATA);
            if (unit != null) {
                List<InfoMultiBean> infoMultiBeans = infoMultiAdapter.getData();
                if (requestCode == OrderingUnitRequestCode) {
                    //訂貨單位
                    mPresenter.setOrderingUnit(infoMultiBeans, unit);
                    infoMultiAdapter.notifyItemChanged(mPresenter.orderingUnitIndex);
                } else if (requestCode == ReceivingUnitRequestCode) {
                    //收貨單位
                    mPresenter.setReceivingUnit(infoMultiBeans, unit);
                    infoMultiAdapter.notifyItemChanged(mPresenter.receivingUnitIndex);
                }
            }
        }
    }
}
