package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerStorageListComponent;
import com.gingersoft.supply_chain.mvp.bean.OrderBean;
import com.gingersoft.supply_chain.mvp.contract.StorageListContract;
import com.gingersoft.supply_chain.mvp.presenter.StorageListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchasePageAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.StorageAdapter;
import com.gingersoft.supply_chain.mvp.ui.widget.ScreenView;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/10/2020 18:09
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class StorageListFragment extends BaseSupplyChainFragment<StorageListPresenter> implements StorageListContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_purchase_list)
    QMUITopBar mTopBar;
    @BindView(R2.id.ed_food_ingredients_search)
    EditText edFoodIngredientsSearch;
    @BindView(R2.id.layout_purchase_list_screen)
    QMUILinearLayout layoutPurchaseListScreen;
    @BindView(R2.id.layout_food_ingredients_search)
    LinearLayout layoutFoodIngredientsSearch;
    @BindView(R2.id.screen_view)
    ScreenView screenView;
    @BindView(R2.id.purchase_list_tabSegment)
    QMUITabSegment2 mTabSegment;
    @BindView(R2.id.contentViewPager)
    ViewPager2 contentViewPager;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnSave;

    String[] tabs = new String[]{"全部", "待收貨", "部分收貨", "全部收貨", "拒收"};

    public static StorageListFragment newInstance() {
        StorageListFragment fragment = new StorageListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerStorageListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_purchase_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar();
        initTabAndData();
    }

    private void initTopBar() {
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("入庫列表");
        btnSave.setVisibility(View.GONE);
    }

    private void initTabAndData() {
        QMUITabBuilder builder = mTabSegment.tabBuilder()
                .setNormalColor(ContextCompat.getColor(mContext, R.color.color_86))
                .setSelectColor(ContextCompat.getColor(mContext, R.color.theme_color));

        List<OrderBean> orderBeans = new ArrayList<>();
//        for (int i = 0; i < 10; i++) {
//            OrderBean orderBean = new OrderBean("S0001", 5, 11.11, 1, System.currentTimeMillis());
//            orderBeans.add(orderBean);
//        }
        StorageAdapter storageAdapter = new StorageAdapter(orderBeans);
        PurchasePageAdapter adapter = new PurchasePageAdapter(storageAdapter, tabs.length);
        contentViewPager.setAdapter(adapter);
        mTabSegment.setupWithViewPager(contentViewPager);
        mTabSegment.setIndicator(new QMUITabIndicator(
                QMUIDisplayHelper.dp2px(getContext(), 2), false, false));
        for (String tab : tabs) {
            mTabSegment.addTab(builder.setText(tab).build(getContext()));
        }
        mTabSegment.setMode(QMUITabSegment.MODE_FIXED);
        mTabSegment.addOnTabSelectedListener(new QMUIBasicTabSegment.OnTabSelectedListener() {
            @Override
            public void onTabSelected(int index) {
//                mPresenter.getOrderList("", orderState[index], pageIndex);
            }

            @Override
            public void onTabUnselected(int index) {

            }

            @Override
            public void onTabReselected(int index) {

            }

            @Override
            public void onDoubleTap(int index) {
                mTabSegment.clearSignCountView(index);
            }
        });
    }

    @OnClick({R2.id.layout_purchase_list_screen})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.layout_purchase_list_screen) {
            screenView.setVisibility(screenView.getVisibility() == View.VISIBLE ? View.GONE : View.VISIBLE);
        }
    }
}
