package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.ui.view.timeselect.TimePickerView;
import com.gingersoft.gsa.cloud.common.utils.time.TimePickerUtils;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;

import java.util.Calendar;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/3
 * Time: 14:31
 * Use: 篩選
 */
public class ScreenView extends FrameLayout implements View.OnClickListener {
    @BindView(R2.id.ed_screen_purchase_order_num)
    EditText edOrderNum;
    @BindView(R2.id.iv_screen_purchase_order_switch_num)
    ImageView ivSwitchOrderNum;
    @BindView(R2.id.ed_screen_purchase_order_supplier_name)
    EditText edSupplierName;
    @BindView(R2.id.iv_screen_purchase_order_switch_supplier_name)
    ImageView ivSwitchSupplierName;
    @BindView(R2.id.ed_screen_purchase_order_food_name)
    EditText edFoodName;
    @BindView(R2.id.iv_switch_food_name)
    ImageView ivSwitchFoodName;
    @BindView(R2.id.tv_screen_purchase_order_start_time)
    TextView tvStartTime;
    @BindView(R2.id.tv_screen_purchase_order_end_time)
    TextView tvEndTime;
    @BindView(R2.id.iv_switch_time)
    ImageView ivSwitchTime;
    @BindView(R2.id.layout_purchase_list_screen)
    LinearLayout screenLayout;


    private Calendar startTime = Calendar.getInstance();
    private Calendar endTime = startTime;


    public ScreenView(Context context) {
        this(context, null);
    }

    public ScreenView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ScreenView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        View view = View.inflate(context, R.layout.pop_purchase_order_screen, null);
        ButterKnife.bind(this, view);
        tvStartTime.setText(TimeUtils.getCurrentDate(TimeUtils.DATE_FORMAT_DATE));
        tvEndTime.setText(TimeUtils.getCurrentDate(TimeUtils.DATE_FORMAT_DATE));

        this.addView(view);
    }

    public ScreenView setLayoutMarginTop(int marginTop) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.topMargin = marginTop;
        screenLayout.setLayoutParams(params);
        return this;
    }

    @OnClick({R2.id.layout_screen_view, R2.id.btn_screen_purchase_order_confirm, R2.id.btn_screen_purchase_order_cancel, R2.id.iv_screen_purchase_order_switch_num, R2.id.iv_screen_purchase_order_switch_supplier_name, R2.id.iv_switch_food_name, R2.id.tv_screen_purchase_order_start_time, R2.id.tv_screen_purchase_order_end_time, R2.id.iv_switch_time})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.layout_screen_view) {
            this.setVisibility(GONE);
        } else if (viewId == R.id.btn_screen_purchase_order_confirm) {
            //確認
            this.setVisibility(GONE);
        } else if (viewId == R.id.btn_screen_purchase_order_cancel) {
            //取消
            this.setVisibility(GONE);
        } else if (viewId == R.id.iv_screen_purchase_order_switch_num) {
            //切換訂單編號排序

        } else if (viewId == R.id.iv_screen_purchase_order_switch_supplier_name) {
            //切換供應商排序

        } else if (viewId == R.id.iv_switch_food_name) {
            //切換食品名排序

        } else if (viewId == R.id.tv_screen_purchase_order_start_time) {
            //選擇開始時間
            TimePickerView timePickerView = TimePickerUtils.showDatePicker(getContext(), (date, v1) -> {
                startTime.setTime(date);
                tvStartTime.setText(TimeUtils.DATE_FORMAT_DATE.format(date));
            });
            timePickerView.setDate(startTime);
        } else if (viewId == R.id.tv_screen_purchase_order_end_time) {
            //選擇結束時間
            TimePickerView timePickerView = TimePickerUtils.showDatePicker(getContext(), (date, v1) -> {
                endTime.setTime(date);
                tvEndTime.setText(TimeUtils.DATE_FORMAT_DATE.format(date));
            });
            timePickerView.setDate(endTime);
        } else if (viewId == R.id.iv_switch_time) {
            //切換時間的排序

        }
    }
}