package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.common.ui.view.BeveLabelView;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

import java.util.ArrayList;
import java.util.List;

import androidx.recyclerview.widget.GridLayoutManager;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：食品细项第一层适配器
 */

public class FineItemOneAdapter extends DefaultAdapter<Modifier> {

    private Context mContext;

    //所有沽清类型
    private List<SoldoutCtrFood> mCurrentSlodoutFoodList_Full = new ArrayList<>();

    private int mOrderNumberShowSize;
    private int mOrderNumberFontSize;
    private int mModFontSize;

    private int mColwidth;
    private int mColHeight;

    private int currentSelectPosition = 0;

    private int user_qty;//在进入的的数量
    public boolean check_qty = false;//是否检查数理

    public FineItemOneAdapter(Context context, List<Modifier> infos) {
        super(infos);
        this.mContext = context;
        this.mOrderNumberShowSize = GsaCloudApplication.uiStyleConfiguration.getSoldoutModFlagHeightValue();
        this.mOrderNumberFontSize = GsaCloudApplication.uiStyleConfiguration.getSoldoutModFlagFontSizeValue();
        this.mModFontSize = GsaCloudApplication.uiStyleConfiguration.getModFontSizeValue();
        this.mColHeight = GsaCloudApplication.uiStyleConfiguration.getModBtnHeightValue();
        int modColumn = GsaCloudApplication.uiStyleConfiguration.getModColumnValue();
        this.mColwidth = (int) ((DeviceUtils.getScreenWidth(context) / modColumn));

    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Modifier> getHolder(View v, int viewType) {
        return new DateTimeItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_fine;
    }

    class DateTimeItemHolder extends BaseHolder<Modifier> {

        @BindView(R2.id.rl_container)
        RelativeLayout rl_container;
        @BindView(R2.id.tv_food_name)
        TextView tv_food_name;
        @BindView(R2.id.tv_number)
        TextView tv_number;
        //        @BindView(R.id.tv_status)
//        TextView tv_status;
        @BindView(R2.id.tv_soldout)
        TextView tv_soldout;
        @BindView(R2.id.iv_qtySold)
        ImageView iv_qtySold;
        @BindView(R2.id.blv_soldout)
        BeveLabelView blv_soldout;

        public DateTimeItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Modifier datasBean, int position) {

            setFood(datasBean);
            setNumber(datasBean);
            setStatus(datasBean);

            setOnItemClickListener(new OnViewClickListener() {

                @Override
                public void onViewClick(View view, int position) {
                    if (mOnItemClickListener != null) {
                        //记录当前操作的position
                        currentSelectPosition = position;
                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
        }

        public void setFood(Modifier datasBean) {
            String desc = "";
//            switch (GsaCloudApplication.androidSetting.getDataLanguage()) {
//                case 1:
//                    desc = datasBean.getDesc1();
//                    break;
//                case 2:
//                    desc = datasBean.getDesc2();
//                    break;
//                case 3:
//                    desc = datasBean.getDesc3();
//                    break;
//            }
//            if (desc == null || desc.trim().length() == 0) {
            desc = datasBean.getModifierName();
//            }

//            tv_food_name.setMaxWidth(mColwidth);
//            tv_food_name.setMinWidth(mColwidth);
//            tv_food_name.setWidth(mColwidth);

            tv_food_name.setText(desc);
            tv_food_name.setTextSize(mModFontSize);
            tv_food_name.setHeight(mColHeight);
            tv_food_name.setGravity(Gravity.CENTER);
            tv_food_name.setSingleLine(false);

            GridLayoutManager.LayoutParams lp = (GridLayoutManager.LayoutParams) rl_container.getLayoutParams();
            lp.height = mColHeight;
            lp.width = mColwidth;
            rl_container.setLayoutParams(lp);

            /**
             * 设置字体颜色以及块颜色
             */
//            if (mColorList != null) {
//                //后台有设置颜色当前选中高亮色,没有选中默认使用后台配置的颜色
//                if (datasBean.isSelected()) {
//                    tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.colorAccent));
//                    tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                } else {
//                    for (Color.DatasBean cs : mColorList) {
//                        if (cs.getColorid() == datasBean.getColor()) {
//                            if (!TextUtils.isEmpty(cs.getAndroidColor())) {
//                                tv_food_name.setBackgroundColor(android.graphics.Color.parseColor(cs.getAndroidColor()));
//                            } else {
//                                tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
//                            }
//                            if (!TextUtils.isEmpty(cs.getAndroidfontcolor())) {
//                                tv_food_name.setTextColor(android.graphics.Color.parseColor(cs.getAndroidfontcolor()));
//                            } else {
//                                tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                            }
//                            break;
//                        }
//                    }
//                }
//            } else {
            //后台没有设置颜色当前选中高亮色,没有选中默认使用绿色
//                if (datasBean.isSelected()) {
//                    tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.orange_500));
//                    tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                } else {
            tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
            tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                }
//            }
        }

        public void setNumber(Modifier datasBean) {
            tv_number.setMaxHeight(mOrderNumberShowSize);
            tv_number.setMinHeight(mOrderNumberShowSize);
            tv_number.setTextSize(mOrderNumberFontSize);
            tv_number.setMinWidth(20);
            tv_number.setTextColor(android.graphics.Color.parseColor("#000000"));
            tv_number.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
            tv_number.setGravity(Gravity.CENTER);

            ViewGroup.MarginLayoutParams mp = new ViewGroup.MarginLayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);  //item的宽高
            mp.setMargins(0, 0, 0, 0);//分别是margin_top那四个属性
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(mp);
            lp.width = ArmsUtils.dip2px(mContext, 16);
            lp.height = ArmsUtils.dip2px(mContext, 16);
            lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            tv_number.setLayoutParams(lp);

            tv_number.setVisibility(View.INVISIBLE);
        }

        private void setStatus(Modifier datasBean) {
//            tv_soldout.setMaxHeight(mOrderNumberShowSize);
//            tv_soldout.setMinHeight(mOrderNumberShowSize);
            tv_soldout.setTextSize(mOrderNumberFontSize);
//            tv_soldout.setTextColor(Color.parseColor("#FFFFFF"));
            tv_soldout.setBackgroundDrawable(mContext.getResources().getDrawable(R.drawable.meal_shape_remaining_number_bg));
//            tv_soldout.setMinWidth(20);
//            tv_soldout.setTextSize(10);
//            tv_soldout.setGravity(Gravity.CENTER);

            tv_soldout.setVisibility(View.INVISIBLE);
            iv_qtySold.setVisibility(View.INVISIBLE);
            blv_soldout.setVisibility(View.INVISIBLE);
            /**
             * 设置当前状态
             */
            String qty = datasBean.getCurrentMaxNumber();
            if (TextUtils.isEmpty(qty)) {
                tv_soldout.setVisibility(View.INVISIBLE);
            } else {
                if (qty.equalsIgnoreCase("售罄") || qty.equalsIgnoreCase("暫停")) {
                    blv_soldout.setLableText(qty);
                    blv_soldout.setVisibility(View.VISIBLE);
                } else {
                    tv_soldout.setVisibility(View.VISIBLE);
                    tv_soldout.setText(qty);
                }
            }
        }
    }

    public void setCurrentSlodoutFoodList_Full(List<SoldoutCtrFood> currentSlodoutFoodList_Full) {
        this.mCurrentSlodoutFoodList_Full = currentSlodoutFoodList_Full;
    }

    public int getUser_qty() {
        return user_qty;
    }

    public void setUser_qty(int user_qty) {
        this.user_qty = user_qty;
    }

    public boolean isCheck_qty() {
        return check_qty;
    }

    public void setCheck_qty(boolean check_qty) {
        this.check_qty = check_qty;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Modifier datasBean, int position);

    }
}
