package com.gingersoft.gsa.cloud.login.mvp.ui.activity.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.contract.ChooseRestaurantContract;
import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.model.ChooseRestaurantModel;


@Module
public class ChooseRestaurantModule {
    private ChooseRestaurantContract.View view;

    /**
     * 构建ChooseRestaurantModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     * @param view
     */
    public ChooseRestaurantModule(ChooseRestaurantContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    ChooseRestaurantContract.View provideChooseRestaurantView(){
        return this.view;
    }

    @ActivityScope
    @Provides
    ChooseRestaurantContract.Model provideChooseRestaurantModel(ChooseRestaurantModel model){
        return model;
    }
}