package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.common.core.settlement.SettlementReport;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-11-27
 * @update date: 2020-11-27
 * @description:
 */
@Data
public class PrintCleanMachineContent implements PrintContent, Parcelable {

    private String yesterdayTime;
    private SettlementReport.VoBean vo;
    private String restaurantOperationTime;
    private List<SettlementReport.AnalysisBean> analysis;
    private List<SettlementReport.CashBean> cash;
    private String currentTime;
    private String startTime;

    public PrintCleanMachineContent() {
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.yesterdayTime);
        dest.writeParcelable(this.vo, flags);
        dest.writeString(this.restaurantOperationTime);
        dest.writeTypedList(this.analysis);
        dest.writeTypedList(this.cash);
        dest.writeString(this.currentTime);
        dest.writeString(this.startTime);
    }

    protected PrintCleanMachineContent(Parcel in) {
        this.yesterdayTime = in.readString();
        this.vo = in.readParcelable(SettlementReport.VoBean.class.getClassLoader());
        this.restaurantOperationTime = in.readString();
        this.analysis = in.createTypedArrayList(SettlementReport.AnalysisBean.CREATOR);
        this.cash = in.createTypedArrayList(SettlementReport.CashBean.CREATOR);
        this.currentTime = in.readString();
        this.startTime = in.readString();
    }

    public static final Creator<PrintCleanMachineContent> CREATOR = new Creator<PrintCleanMachineContent>() {
        @Override
        public PrintCleanMachineContent createFromParcel(Parcel source) {
            return new PrintCleanMachineContent(source);
        }

        @Override
        public PrintCleanMachineContent[] newArray(int size) {
            return new PrintCleanMachineContent[size];
        }
    };
}
