/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.discovery;

import android.content.Context;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.discovery.DeviceInfo;
import com.epson.epos2.discovery.DiscoveryListener;
import com.epson.epos2.discovery.FilterOption;
import java.lang.reflect.Method;

public class Discovery {
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogCallFunctionMethod = null;
    private static Method mOutputLogReturnFunctionMethod = null;
    private static Method mOutputExceptionMethod = null;
    private static Method mOutputLogEventMethod = null;
    private static final int NO_EXCEPTION = 0;
    public static final int TYPE_ALL = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_HYBRID_PRINTER = 2;
    public static final int TYPE_DISPLAY = 3;
    public static final int TYPE_KEYBOARD = 4;
    public static final int TYPE_SCANNER = 5;
    public static final int TYPE_SERIAL = 6;
    public static final int TYPE_CCHANGER = 7;
    public static final int TYPE_POS_KEYBOARD = 8;
    public static final int TYPE_CAT = 9;
    public static final int TYPE_MSR = 10;
    public static final int TYPE_OTHER_PERIPHERAL = 11;
    public static final int TYPE_GFE = 12;
    public static final int PORTTYPE_ALL = 0;
    public static final int PORTTYPE_TCP = 1;
    public static final int PORTTYPE_BLUETOOTH = 2;
    public static final int PORTTYPE_USB = 3;
    public static final int MODEL_ALL = 0;
    private static final int MODEL_TM_PRINTER = 1;
    private static final int MODEL_TM_INTELLIGENT = 2;
    public static final int FILTER_NONE = 1;
    public static final int FILTER_NAME = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static DiscoveryListener mDiscoveryListener;
    private static boolean mRunning;

    private static boolean isRunning() {
        return mRunning;
    }

    private static void setRunning(boolean running) {
        mRunning = running;
    }

    private static final native int nativeEpos2DiscoveryStart(Object var0, FilterOption var1);

    private static final native int nativeEpos2DiscoveryStop();

    public static synchronized void start(Context context, FilterOption filterOption, DiscoveryListener listener) throws Epos2Exception {
        Discovery.outputLogCallFunction("start", context, filterOption.getPortType(), filterOption.getBroadcast(), filterOption.getDeviceModel(), filterOption.getEpsonFilter(), filterOption.getDeviceType(), filterOption.getBondedDevices(), listener);
        try {
            int errStatus = 0;
            if (mRunning) {
                throw new Epos2Exception(5);
            }
            if (context == null || filterOption == null || listener == null) {
                throw new Epos2Exception(1);
            }
            mDiscoveryListener = listener;
            errStatus = Discovery.nativeEpos2DiscoveryStart(context, filterOption);
            if (0 != errStatus) {
                mDiscoveryListener = null;
                throw new Epos2Exception(errStatus);
            }
            mRunning = true;
        }
        catch (Epos2Exception ex) {
            Discovery.outputException("start", ex);
            Discovery.outputLogReturnFunction("start", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        Discovery.outputLogReturnFunction("start", 0, context, filterOption.getPortType(), filterOption.getBroadcast(), filterOption.getDeviceModel(), filterOption.getEpsonFilter(), filterOption.getDeviceType(), filterOption.getBondedDevices(), listener);
    }

    public static synchronized void stop() throws Epos2Exception {
        Discovery.outputLogCallFunction("stop", new Object[0]);
        try {
            int errStatus = 0;
            if (!mRunning) {
                throw new Epos2Exception(5);
            }
            errStatus = Discovery.nativeEpos2DiscoveryStop();
            if (errStatus != 0) {
                throw new Epos2Exception(errStatus);
            }
            mDiscoveryListener = null;
            mRunning = false;
        }
        catch (Epos2Exception ex) {
            Discovery.outputException("stop", ex);
            Discovery.outputLogReturnFunction("stop", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        Discovery.outputLogReturnFunction("stop", 0, new Object[0]);
    }

    protected static void onDiscovery(DeviceInfo deviceInfo) {
        Discovery.outputLogCallFunction("onDiscovery", deviceInfo);
        if (null != mDiscoveryListener) {
            Discovery.outputLogEvent("onDiscovery", "deviceType->", deviceInfo.getDeviceType(), "target->", deviceInfo.getTarget(), "deviceName->", deviceInfo.getDeviceName(), "ipAddress->", deviceInfo.getIpAddress(), "macAddress->", deviceInfo.getMacAddress(), "bdAddress->", deviceInfo.getBdAddress());
            mDiscoveryListener.onDiscovery(deviceInfo);
        }
        Discovery.outputLogReturnFunction("onDiscovery", 0, deviceInfo);
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogCallFunctionMethod = mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            mOutputLogCallFunctionMethod.setAccessible(true);
            mOutputLogReturnFunctionMethod = mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            mOutputLogReturnFunctionMethod.setAccessible(true);
            mOutputExceptionMethod = mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            mOutputExceptionMethod.setAccessible(true);
            mOutputLogEventMethod = mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            mOutputLogEventMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogCallFunction(String methodName, Object ... param) {
        try {
            mOutputLogCallFunctionMethod.invoke(mClassOutputLog, methodName, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            mOutputLogReturnFunctionMethod.invoke(mClassOutputLog, methodName, 0, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void outputException(String methodName, Exception exception) {
        try {
            mOutputExceptionMethod.invoke(mClassOutputLog, methodName, 0, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private static void outputLogEvent(String methodName, Object ... param) {
        try {
            mOutputLogEventMethod.invoke(mClassOutputLog, methodName, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
            Discovery.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        mDiscoveryListener = null;
        mRunning = false;
    }
}

