package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.core.settlement.SettlementReport;
import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerLiquidationHistoryComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.LiquidationHistoryContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SettlementHistoryListBean;
import com.gingersoft.gsa.cloud.main.mvp.presenter.LiquidationHistoryPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.LiquidationHistoryAdapter;
import com.gingersoft.gsa.cloud.main.mvp.ui.view.StartEndTimePickerView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import butterknife.BindView;

import static com.gingersoft.gsa.cloud.main.mvp.ui.activity.SettlementActivity.SETTLEMENT_TYPE_NOMAL;
import static com.gingersoft.gsa.cloud.main.mvp.ui.activity.SettlementActivity.SETTLEMENT_TYPE_TAG;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:清機歷史記錄
 *
 * @author admin
 */
public class LiquidationHistoryActivity extends BaseActivity<LiquidationHistoryPresenter> implements LiquidationHistoryContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar topbar;
    @BindView(R2.id.sv_time_select)
    StartEndTimePickerView svTimeSelect;
    @BindView(R2.id.rv_liquidation_history_list)
    RecyclerView rvLiquidationHistoryList;
    @BindView(R2.id.sr_settlement_history)
    SmartRefreshLayout smartRefreshLayout;
    private int pageIndex = 0;
    private LoadService register;
    private int mSettlementType;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerLiquidationHistoryComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_liquidation_history;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        register = LoadSir.getDefault().register(smartRefreshLayout, (Callback.OnReloadListener) v -> {
            pageIndex = 0;
            loadInfo();
        });
        smartRefreshLayout.setPrimaryColorsId(android.R.color.transparent, android.R.color.black);
        svTimeSelect.setOnUpdateTimePicker((startTime, endTime) -> {
            pageIndex = 0;
            mPresenter.getLiquidationHistory(pageIndex, startTime, endTime);
        });
        mPresenter.initAdapter();
        loadInfo();
        smartRefreshLayout.setOnRefreshListener(refreshLayout -> {
            pageIndex = 0;
            loadInfo();
        });
        smartRefreshLayout.setOnLoadMoreListener(refreshLayout -> {
            pageIndex++;
            loadInfo();
        });
    }

    private void loadInfo() {
        mPresenter.getLiquidationHistory(pageIndex, svTimeSelect.getStartTime(), svTimeSelect.getEndTime());
    }

    @Override
    public void initIntent() {
        mSettlementType = getIntent().getIntExtra(SETTLEMENT_TYPE_TAG, SETTLEMENT_TYPE_NOMAL);
    }

    @Override
    public void initTopBar() {
        topbar.addLeftBackImageButton().setOnClickListener(v -> finish());
        topbar.setTitle(R.string.str_title_history_settiement);
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void setAdapter(LiquidationHistoryAdapter liquidationHistoryAdapter) {
        rvLiquidationHistoryList.setAdapter(liquidationHistoryAdapter);
        liquidationHistoryAdapter.setOnItemClickListener((adapter, view, position) -> {
            SettlementHistoryListBean item = liquidationHistoryAdapter.getItem(position);
            String startTime = TimeUtils.stampToData(TimeUtils.DEFAULT_DATE_FORMAT_YMDHM, item.getOperationStartTime());
            String endTime = TimeUtils.stampToData(TimeUtils.DEFAULT_DATE_FORMAT_YMDHM, item.getOperationTime());
            mPresenter.getSettlementReport(startTime, endTime);
        });
        rvLiquidationHistoryList.addItemDecoration(AppConstant.getItemDecoration(this));
    }

    @Override
    public void setLoadNoMoreData() {
        smartRefreshLayout.finishLoadMoreWithNoMoreData();
    }

    @Override
    public void setNoData() {
        smartRefreshLayout.finishLoadMore();
        smartRefreshLayout.finishRefresh();
        register.showCallback(EmptyCallback.class);
    }

    @Override
    public void finisLoad() {
        register.showSuccess();
        smartRefreshLayout.finishLoadMore();
        smartRefreshLayout.finishRefresh();
    }

    @Override
    public void toSettlementReportActivity(SettlementReport mSettlementReportBean) {
        Intent intent = new Intent(this, SettlementReportActivity.class);
        intent.putExtra("settlementReportBean", mSettlementReportBean);
        intent.putExtra(SETTLEMENT_TYPE_TAG, mSettlementType);
        launchActivity(intent);
    }
}
