package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.ui.adapter.ConsumptionReasonAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WareHousingOrderFoodAdapter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/29/2021 15:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface WarehousingOrderDetailsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void initReason(ConsumptionReasonAdapter consumptionReasonAdapter);

        void initFoodView(WareHousingOrderFoodAdapter wareHousingOrderFoodAdapter);
        /**
         * 新增入庫單成功
         */
        void addOrderSuccess();

        void setOrderAllInfo();

        void showSnCodePopup(PurchaseFoodBean infoVosBean);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        /**
         * 獲取庫存入庫原因
         */
        Observable<BaseResult> getMultipleStorageCauseList(Map<String, Object> map);

        /**
         * 生成入庫單
         */
        Observable<BaseResult> addWarehousingOrder(RequestBody requestBody);

        /**
         * 獲取入庫單詳情
         *
         * @param warehousingOrderId 入庫訂單id
         */
        Observable<BaseResult> getWarehousingOrderDetails(int warehousingOrderId);

        /**
         * 查詢食品sn碼
         * @param encodeFoodNo 食品編號
         * @param encodeOrderNo 訂單編號
         */
        Observable<BaseResult> querySnCodes(String encodeFoodNo, String encodeOrderNo);
    }
}
