package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.gingersoft.supply_chain.mvp.contract.SnCodeListContract;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.HashMap;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/26/2021 19:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class SnCodeListPresenter extends BasePresenter<SnCodeListContract.Model, SnCodeListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public SnCodeListPresenter(SnCodeListContract.Model model, SnCodeListContract.View rootView) {
        super(model, rootView);
    }

    /**
     * 查詢sn碼記錄
     *
     * @param infoType                   數據類型 0入庫流水SN碼，1出庫流水SN碼
     * @param warehousingOrderDetailsIds
     */
    public void querySnCodeList(int infoType, String warehousingOrderDetailsIds) {
        Map<String, Object> map = new HashMap<>(2);
        //入库SN编码查询  statesSn   0
        //出库SN编码查询  statesSn   1
        map.put("statesSn", infoType);
        if (infoType == 0) {
            //入庫傳這個
            map.put("warehousingEncodeSnIdList", warehousingOrderDetailsIds);
        } else {
            if (TextUtil.isEmptyOrNullOrUndefined(warehousingOrderDetailsIds)) {
                mRootView.showMessage("出庫單號獲取失敗，請退出重試");
                return;
            } else {
                //出庫傳這個
                map.put("consumeEncodeSnIdList", warehousingOrderDetailsIds);
            }
        }
        mModel.querySnCodeList(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(AppConstant.QUERY_LOADING))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult != null && baseResult.isSuccess()) {
                            mRootView.initAdapter(GsonUtils.jsonToList(baseResult.getData(), PurchaseFoodEncodeSn.class));
                        }
                    }
                });
    }

    /**
     * 查詢sn碼記錄
     */
    public void queryInStockSnCodes(String foodNo) {
        mModel.queryInStockSnCodes(foodNo)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(AppConstant.QUERY_LOADING))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult != null && baseResult.isSuccess()) {
                            mRootView.initAdapter(GsonUtils.jsonToList(baseResult.getData(), PurchaseFoodEncodeSn.class));
                        }
                    }
                });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }
}
