package com.gingersoft.supply_chain.mvp.ui.adapter.binder;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.binder.QuickItemBinder;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.SnInoutBoundRecordBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/5/12
 * Time: 12:29
 * Use:
 */
public class SnInOutRecordBinder extends QuickItemBinder<SnInoutBoundRecordBean> {
    @Override
    public int getLayoutId() {
        return R.layout.item_sn_inout_bound_record;
    }

    @Override
    public void convert(@NotNull BaseViewHolder viewHolder, SnInoutBoundRecordBean snInoutBoundRecordBean) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(snInoutBoundRecordBean.getImages())) {
            GlideUtils.display(viewHolder.itemView.getContext(), viewHolder.getView(R.id.iv_inout_bound_food_img), snInoutBoundRecordBean.getImages());
        } else {
            viewHolder.setImageResource(R.id.iv_inout_bound_food_img, R.drawable.img_small_default);
        }

        viewHolder.setText(R.id.iv_inout_bound_food_name, snInoutBoundRecordBean.getName());
        viewHolder.setText(R.id.iv_inout_bound_food_no, snInoutBoundRecordBean.getEncodeFoodNo());

        if (snInoutBoundRecordBean.getStatus() == SnInoutBoundRecordBean.NOT_OUT_STOCK) {
            //在庫
            viewHolder.setTextColor(R.id.iv_inout_bound_food_state, ContextCompat.getColor(viewHolder.itemView.getContext(), R.color.theme_color));
            viewHolder.setText(R.id.iv_inout_bound_food_state, R.string.str_in_warehouse);
        } else if (snInoutBoundRecordBean.getStatus() == SnInoutBoundRecordBean.OUT_STOCK) {
            viewHolder.setTextColor(R.id.iv_inout_bound_food_state, ContextCompat.getColor(viewHolder.itemView.getContext(), R.color.theme_333_color));
            viewHolder.setText(R.id.iv_inout_bound_food_state, R.string.str_already_out_warehouse);
        } else {
            viewHolder.setText(R.id.iv_inout_bound_food_state, snInoutBoundRecordBean.getStatus() + "");
        }
    }
}
