package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.loadsir.EmptyCallback;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.MarginDecoration;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerInflowWaterComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseWarehousingOrderDetailsVO;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.gingersoft.supply_chain.mvp.contract.InflowWaterContract;
import com.gingersoft.supply_chain.mvp.presenter.InflowWaterPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WareHousingDetailsAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.DeviceUtils;
import com.kingja.loadsir.core.LoadSir;

import java.util.List;

import butterknife.BindView;


/**
 * 入庫流水列表的 fragment
 *
 * @author admin
 */
public class InflowWaterFragment extends BaseSupplyChainFragment<InflowWaterPresenter> implements InflowWaterContract.View {

    private WareHousingDetailsAdapter wareHousingDetailsAdapter;

    @BindView(R2.id.rv_purchase_list_content)
    public RecyclerView recyclerView;

    public static InflowWaterFragment newInstance() {
        InflowWaterFragment fragment = new InflowWaterFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerInflowWaterComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.recycler_view_item, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        recyclerView.addItemDecoration(new MarginDecoration((int) DeviceUtils.dpToPixel(requireContext(), 8)));
        loadService = LoadSir.getDefault().register(recyclerView);
    }

    public void loadData(PurchaseWarehousingOrderDetailsVO purchaseWarehousingOrderDetailsVO, List<WarehouseDetailsBean> warehouseDetailsBeans, int currentIndex) {
        if (wareHousingDetailsAdapter == null) {
            wareHousingDetailsAdapter = new WareHousingDetailsAdapter(warehouseDetailsBeans, currentIndex);
            wareHousingDetailsAdapter.setOnItemClickListener((adapter, view, position) -> {
                WarehouseDetailsBean item = wareHousingDetailsAdapter.getItem(position);
                        if (purchaseWarehousingOrderDetailsVO.getFoodMarkSn() == PurchaseFoodBean.HAS_SN) {
                            //SN食材
                            BaseFragmentActivity fragmentActivity = (BaseFragmentActivity) requireActivity();
                            fragmentActivity.start(SnCodeListFragment.newInstance(currentIndex, item));
                        }
            }

            );
            recyclerView.setAdapter(wareHousingDetailsAdapter);
        } else {
            wareHousingDetailsAdapter.setType(currentIndex);
            wareHousingDetailsAdapter.setList(warehouseDetailsBeans);
        }
        if (CollectionUtils.isNotNullOrEmpty(warehouseDetailsBeans)) {
            loadService.showSuccess();
        } else {
            loadService.showCallback(EmptyCallback.class);
        }
    }

}
