package com.gingersoft.gsa.cloud.ui.adapter;

import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use: 繼承重寫自己的layout
 */
public abstract class BaseSelectorAdapter<T, VH extends BaseViewHolder> extends BaseQuickAdapter<T, VH> {

    private int selectedIndex = 0;
    private int selectedBg;
    private int unSelectedBg;

    private int selectColor;
    private int unSelectColor;

    public BaseSelectorAdapter(int layoutRes, @Nullable List<T> data) {
        super(layoutRes, data);
        selectedBg = R.drawable.shape_white_eight_corners_bg;
        unSelectedBg = R.drawable.shape_theme_eight_corners_bg;
        selectColor = R.color.s_btn_blue_3c_text;
        unSelectColor = R.color.color_ccc;
    }

    protected void notifyCheckState(int position, TextView tvName, View view) {
        if (position == selectedIndex) {
            view.setBackground(ContextCompat.getDrawable(getContext(), selectedBg));
            tvName.setTextColor(selectColor);
            tvName.setSelected(true);
        } else {
            view.setBackground(ContextCompat.getDrawable(getContext(), unSelectedBg));
            tvName.setTextColor(unSelectColor);
            tvName.setSelected(false);
        }
    }

    public BaseSelectorAdapter setSelectedBg(int selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public BaseSelectorAdapter setUnSelectedBg(int unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public BaseSelectorAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public BaseSelectorAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public BaseSelectorAdapter setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
        return this;
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
