package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.WarehousingInventoryModule;
import com.gingersoft.supply_chain.mvp.contract.WarehousingInventoryContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehousingInventoryFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/22/2021 15:10
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = WarehousingInventoryModule.class, dependencies = AppComponent.class)
public interface WarehousingInventoryComponent {
    void inject(WarehousingInventoryFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        WarehousingInventoryComponent.Builder view(WarehousingInventoryContract.View view);

        WarehousingInventoryComponent.Builder appComponent(AppComponent appComponent);

        WarehousingInventoryComponent build();
    }
}