package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/21
 * Time: 15:54
 * Use:
 */
@Data
public class MeasurementUnitBean {
    private boolean success;
    private long sysTime;
    private DataBean data;
    private String errMsg;

    @Data
    public static class DataBean {
        private int count;
        private List<Unit> list;

        @Data
        public static class Unit implements Serializable {

            private static final long serialVersionUID = -4464228028817022515L;
            private int id;
            private int uid;
            private int brandId;
            private int restaurantId;
            /**
             * 1、重量
             * 2、容積
             * 3、體積
             * 4、面積
             * 5、長度
             */
            private int type;
            private String unitContent;
            private String remarks;
            private long createTime;
            private long updateTime;
            private int deletes;

            public static List<String> measurementUnits = Arrays.asList("重量","容積","體積","面積","長度");
        }
    }
}
