package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.discount;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.core.discount.MemberCoupon;
import com.gingersoft.gsa.cloud.common.loadsir.LoadsirUtil;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerCouponComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.CouponContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.CouponPresenter;
import com.gingersoft.gsa.cloud.ui.adapter.TagViewAdapter;
import com.gingersoft.gsa.cloud.ui.bean.TagViewItem;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class CouponFragment extends BaseFragment<CouponPresenter> implements CouponContract.View {

    @BindView(R2.id.refreshLayout)
    SmartRefreshLayout refreshLayout;
    @BindView(R2.id.rv_coupon)
    RecyclerView rvCoupon;

    @Inject
    List<TagViewItem> mMemberCouponList;
    @Inject
    TagViewAdapter mMemberCouponAdapter;

    private LoadService loadService;

    public static CouponFragment newInstance() {
        CouponFragment fragment = new CouponFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerCouponComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_coupon, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        loadService = LoadSir.getDefault().register(refreshLayout, new Callback.OnReloadListener() {
            @Override
            public void onReload(View v) {
                mPresenter.getMemberWalletList(null, true);
            }
        });

        initAdapter();
        initRefreshLayout();
    }

    @Override
    public void onLazyInitView(@Nullable Bundle savedInstanceState) {
        super.onLazyInitView(savedInstanceState);
        mPresenter.getMemberWalletList(null, true);
    }

    private void initAdapter() {
        rvCoupon.setLayoutManager(createLayoutManager());
        rvCoupon.setAdapter(mMemberCouponAdapter);
        mMemberCouponAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (onCouponItemClickListener != null) {
                onCouponItemClickListener.onItemClick((MemberCoupon) mMemberCouponList.get(position).getTargetObj(), position);
            }
        });
    }

    private RecyclerView.LayoutManager createLayoutManager() {
        return new GridLayoutManager(mContext, 3, LinearLayoutManager.VERTICAL, false) {
            @Override
            public RecyclerView.LayoutParams generateDefaultLayoutParams() {
                return new RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            }
        };
    }

    private void initRefreshLayout() {
        refreshLayout.setOnRefreshListener(new OnRefreshListener() {
            @Override
            public void onRefresh(@NonNull final RefreshLayout refreshLayout) {
                mPresenter.getMemberWalletList(refreshLayout,true);
            }
        });
        refreshLayout.setOnLoadMoreListener(new OnLoadMoreListener() {
            @Override
            public void onLoadMore(@NonNull final RefreshLayout refreshLayout) {
                mPresenter.getMemberWalletList(refreshLayout,false);
            }
        });
        refreshLayout.setEnableLoadMore(false);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(_mActivity, message, true);
        else
            LoadingDialog.showDialogForLoading(_mActivity);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(_mActivity, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        if (intent != null) {
            ArmsUtils.startActivity(intent);
        }
    }

    @Override
    public void killMyself() {
        _mActivity.onBackPressedSupport();
    }

    @Override
    public void returnMemberCouponList(List<MemberCoupon> memberCoupons) {
        List<TagViewItem> tagViewItems = castTagItem(memberCoupons);
        if (mMemberCouponList.size() > 0) {
            mMemberCouponList.clear();
        }
        mMemberCouponList.addAll(tagViewItems);
        mMemberCouponAdapter.notifyDataSetChanged();
    }

    private List<TagViewItem> castTagItem(List<MemberCoupon> memberCoupons) {
        List<TagViewItem> tagViewItems = new ArrayList<>();
        for (MemberCoupon coupon : memberCoupons) {
            TagViewItem<MemberCoupon> tagViewItem = new TagViewItem();
            tagViewItem.setId(coupon.getId());
            tagViewItem.setText(coupon.getRemark());
            tagViewItem.setTargetObj(coupon);
            tagViewItems.add(tagViewItem);
        }
        return tagViewItems;
    }

    @Override
    public void showLoadSirSuccess() {
        loadService.showSuccess();
    }

    @Override
    public void showLoadSirCall(Class<? extends Callback> call) {
        loadService.showCallback(call);
    }

    @Override
    public LoadService getLoadService() {
        return loadService;
    }

    private OnCouponItemClickListener onCouponItemClickListener;

    public void setOnCouponItemClickListener(OnCouponItemClickListener onCouponItemClickListener) {
        this.onCouponItemClickListener = onCouponItemClickListener;
    }

    public interface OnCouponItemClickListener {
        void onItemClick(MemberCoupon item, int position);
    }
}
