package com.gingersoft.gsa.cloud.common.loadsir;

import android.app.Activity;
import android.content.Context;
import android.net.ParseException;
import android.view.View;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.constans.AppConstans;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.jess.arms.utils.ArmsUtils;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.Transport;

import org.json.JSONException;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

import retrofit2.HttpException;

/**
 * @作者: bin
 * @創建時間: 2021-04-07 16:27
 * @更新時間: 2021-04-07 16:27
 * @描述: 反馈页工具类，可根据对应的网络状况显示详细信息
 */
public class LoadsirUtil {

    public static void showCallbackByError(Throwable t, LoadService loadService) {
        if (t instanceof UnknownHostException) {
            loadService.showCallback(ErrorCallback.class);
        } else if (t instanceof SocketTimeoutException) {
            loadService.showCallback(TimeoutCallback.class);
        } else if (t instanceof HttpException) {
            HttpException httpException = (HttpException) t;
            String msg = convertStatusCode(GsaCloudApplication.getAppContext(), httpException);

            Class<ErrorCallback> errorCallback = ErrorCallback.class;

            loadService.setCallBack(errorCallback.getClass(), new OnTransport(msg));
            loadService.showCallback(errorCallback.getClass());

        } else if (t instanceof JsonParseException || t instanceof ParseException || t instanceof JSONException || t instanceof JsonIOException) {

            String msg = ArmsUtils.getString(GsaCloudApplication.getAppContext(), R.string.response_error_data_parsing_error);
            Class<ErrorCallback> errorCallback = ErrorCallback.class;
            loadService.setCallBack(errorCallback.getClass(), new OnTransport(msg));
            loadService.showCallback(errorCallback.getClass());
        }
    }

    private final static String convertStatusCode(Context context, HttpException httpException) {
        String msg = null;
        if (httpException.code() == 500) {
            msg = ArmsUtils.getString(context, R.string.response_error_server_error);
        } else if (httpException.code() == 404) {
            msg = ArmsUtils.getString(context, R.string.response_error_address_does_not_exist);
        } else if (httpException.code() == 403) {
            msg = ArmsUtils.getString(context, R.string.response_error_request_rejected_by_server);
        } else if (httpException.code() == 307) {
            msg = ArmsUtils.getString(context, R.string.response_error_request_was_redirected_to_another_page);
        } else if (httpException.code() == 401) {
            msg = ArmsUtils.getString(context, R.string.response_error_request_logged);
        } else {
            msg = httpException.message();
        }
        return msg;
    }

    private static final class OnTransport implements Transport {

        private Class<?> callbackClass;
        private String msg;

        public OnTransport(Class<?> callbackClass, String msg) {
            this.callbackClass = callbackClass;
            this.msg = msg;
        }

        public OnTransport(String msg) {
            this.msg = msg;
        }

        @Override
        public void order(Context context, View rootView) {
            View tv_loadsir_error_img = rootView.findViewById(R.id.tv_loadsir_error_img);
            tv_loadsir_error_img.setTag(msg);
        }
    }
}
