package com.gingersoft.gsa.cloud.ui.adapter;

import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use:
 */
public class BaseCategoryAdapter extends BaseQuickAdapter<CategoryBean, BaseViewHolder> {

    private int selectedIndex = 0;
    private int selectedBg;
    private int unSelectedBg;

    private int selectColor;
    private int unSelectColor;
    private boolean showDelete = false;

    public BaseCategoryAdapter(@Nullable List<CategoryBean> data) {
        super(R.layout.item_base_category, data);
        addChildClickViewIds(R.id.iv_category_delete);
        selectedBg = R.drawable.shape_left_radio_shadow;
        unSelectedBg = R.color.trans;
        selectColor = R.color.s_btn_blue_3c_text;
        unSelectColor = R.color.color_ccc;
    }

    public BaseCategoryAdapter(int layoutRes, @Nullable List<CategoryBean> data) {
        super(layoutRes, data);
        addChildClickViewIds(R.id.iv_category_delete);
        selectedBg = R.drawable.shape_left_radio_shadow;
        unSelectedBg = R.color.trans;
        selectColor = R.color.s_btn_blue_3c_text;
        unSelectColor = R.color.color_ccc;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, CategoryBean categoryBean) {
        viewHolder.setText(R.id.tv_base_item_title, categoryBean.getCategoryName());
        notifyCheckState(viewHolder.getAdapterPosition(), viewHolder.getView(R.id.tv_base_item_title), viewHolder.getView(R.id.item_layout_root));
        viewHolder.setGone(R.id.iv_category_delete, !showDelete);
    }

    @Override
    public void onBindViewHolder(@NotNull BaseViewHolder holder, int position, @NotNull List<Object> payloads) {
        super.onBindViewHolder(holder, position, payloads);
        //list为空时，必须调用两个参数的onBindViewHolder(@NonNull LabelHolder holder, int position)
        if (payloads.isEmpty()) {
            onBindViewHolder(holder, position);
        } else {
            notifyCheckState(position, holder.getView(R.id.tv_base_item_title), holder.getView(R.id.item_layout_root));
        }
    }

    private void notifyCheckState(int position, TextView tvName, View view) {
        if (position == selectedIndex) {
            view.setBackground(ContextCompat.getDrawable(getContext(), selectedBg));
            tvName.setTextColor(selectColor);
            tvName.setSelected(true);
        } else {
            view.setBackground(ContextCompat.getDrawable(getContext(), unSelectedBg));
            tvName.setTextColor(unSelectColor);
            tvName.setSelected(false);
        }
    }

    public void setShowDelete(boolean showDelete) {
        this.showDelete = showDelete;
        notifyDataSetChanged();
    }

    public BaseCategoryAdapter setSelectedBg(int selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public BaseCategoryAdapter setUnSelectedBg(int unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public BaseCategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public BaseCategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public BaseCategoryAdapter setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
        return this;
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
