package com.joe.print.mvp.ui.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.SimpleAdapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.base.widget.DialogUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.joe.print.R;
import com.joe.print.di.component.DaggerPrintComponent;
import com.joe.print.mvp.contract.PrintContract;
import com.gingersoft.gsa.cloud.base.common.bean.PrinterManger.PrinterManager;
import com.joe.print.mvp.presenter.PrintPresenter;
import com.joe.print.mvp.ui.adapter.PrinterListAdapter;
import com.qmuiteam.qmui.widget.popup.QMUIPopup;
import com.yanzhenjie.recyclerview.OnItemClickListener;
import com.yanzhenjie.recyclerview.widget.DefaultItemDecoration;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/18/2020 14:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 * 透明activity
 * 打印入口
 * 選擇打印方式
 * ----本機打印
 * ----調用本機打印方法
 * ----網絡打印
 * ----获取網絡打印機列表
 */
public class PrintActivity extends BaseActivity<PrintPresenter> implements PrintContract.View, DialogInterface.OnDismissListener {

    private int dialogCount = 0;
    private DialogUtils selectDialog;
    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerPrintComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return 0; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        selectDialog = new DialogUtils(mContext, R.layout.print_dialog_select_device) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                dialogCount++;
                hepler.setViewClick(R.id.local_print, v -> {
                    //本機打印
                    ToastUtils.show(mContext, "功能開發中");
                });
                hepler.setViewClick(R.id.internet_print, v -> {
                    //IP打印
                    if (PrinterManager.getPrinterManager().getDeviceBeans() != null
                            && PrinterManager.getPrinterManager().getDeviceBeans().size() > 0) {
                        //如果本地保存有打印設備
                        showPrinterList();
                    } else {
                        //網絡獲取打印設備
                        mPresenter.getPrinterList(GsaCloudApplication.getRestaurantId(mContext));
                    }
                });
            }
        }.createDialogView().show().setOnDismissListener(this);
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void showPrinterList() {
        //有打印機，彈出彈窗，選擇打印機
        new DialogUtils(mContext, R.layout.print_dialog_internet_list) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                dialogCount++;
                RecyclerView mRvPrintList = hepler.getView(R.id.rv_print_list);
                List<PrinterDeviceBean> deviceBeans = PrinterManager.getPrinterManager().getDeviceBeans();
                PrinterListAdapter printListAdapter = new PrinterListAdapter(deviceBeans);
                mRvPrintList.setLayoutManager(new LinearLayoutManager(mContext));
                //分割线
                mRvPrintList.addItemDecoration(new DefaultItemDecoration(ContextCompat.getColor(mContext, R.color.line_color)));
                mRvPrintList.setAdapter(printListAdapter);
                printListAdapter.setOnItemClickListener((adapter, view, position) -> {
                    Intent intent = new Intent(mContext, OldPrintActivity.class);
                    intent.putExtra("ip", deviceBeans.get(position).getIp());
                    intent.putExtra("port", deviceBeans.get(position).getPort());
                    intent.putExtra("paperType", deviceBeans.get(position).getType());
                    startActivity(intent);
                });
            }
        }.setWidth(ArmsUtils.getScreenWidth(mContext) / 2)
                .setHeight(ArmsUtils.getScreenHeidth(mContext) / 2)
                .createDialogView()
                .show();
        selectDialog.dismiss();
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        dialogCount--;
        if (dialogCount <= 0) {
            finish();
        }
    }
}
