package com.gingersoft.gsa.cloud.database.greendao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;
import com.gingersoft.gsa.cloud.database.greendao.PrinterDeviceBeanDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig foodDaoConfig;
    private final DaoConfig functionDaoConfig;
    private final DaoConfig printerDeviceBeanDaoConfig;

    private final FoodDao foodDao;
    private final FunctionDao functionDao;
    private final PrinterDeviceBeanDao printerDeviceBeanDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        foodDaoConfig = daoConfigMap.get(FoodDao.class).clone();
        foodDaoConfig.initIdentityScope(type);

        functionDaoConfig = daoConfigMap.get(FunctionDao.class).clone();
        functionDaoConfig.initIdentityScope(type);

        printerDeviceBeanDaoConfig = daoConfigMap.get(PrinterDeviceBeanDao.class).clone();
        printerDeviceBeanDaoConfig.initIdentityScope(type);

        foodDao = new FoodDao(foodDaoConfig, this);
        functionDao = new FunctionDao(functionDaoConfig, this);
        printerDeviceBeanDao = new PrinterDeviceBeanDao(printerDeviceBeanDaoConfig, this);

        registerDao(Food.class, foodDao);
        registerDao(Function.class, functionDao);
        registerDao(PrinterDeviceBean.class, printerDeviceBeanDao);
    }
    
    public void clear() {
        foodDaoConfig.clearIdentityScope();
        functionDaoConfig.clearIdentityScope();
        printerDeviceBeanDaoConfig.clearIdentityScope();
    }

    public FoodDao getFoodDao() {
        return foodDao;
    }

    public FunctionDao getFunctionDao() {
        return functionDao;
    }

    public PrinterDeviceBeanDao getPrinterDeviceBeanDao() {
        return printerDeviceBeanDao;
    }

}
