package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.greendao.DiscountDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;
import org.greenrobot.greendao.query.QueryBuilder;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class DiscountDaoUtils {

    private static final String TAG = DiscountDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public DiscountDaoUtils(Context context){
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }

    /**
     * 完成Function记录的插入，如果表未创建，先创建Function表
     * @param discount
     * @return
     */
    public boolean insertDiscount(Discount discount){
        boolean flag = false;
        flag = mManager.getDaoSession().getDiscountDao().insert(discount) == -1 ? false : true;
        Log.i(TAG, "insert discount :" + flag + "-->" + discount.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param discountList
     * @return
     */
    public boolean insertMultDiscount(final List<Discount> discountList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Discount discount : discountList) {
                        mManager.getDaoSession().insertOrReplace(discount);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param discount
     * @return
     */
    public boolean updateDiscount(Discount discount){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(discount);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param discount
     * @return
     */
    public boolean deleteDiscount(Discount discount){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(discount);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Discount.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<Discount> queryAllDiscount(){
        return mManager.getDaoSession().loadAll(Discount.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public Discount queryDiscountById(long key){
        return mManager.getDaoSession().load(Discount.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<Discount> queryDiscountByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(Discount.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询
     * @return
     */
    public List<Discount> queryDiscountByQueryBuilder(){
        QueryBuilder<Discount> queryBuilder = mManager.getDaoSession().queryBuilder(Discount.class);
        long currentTime = System.currentTimeMillis();
//        return queryBuilder.where(queryBuilder.and(
//                DiscountDao.Properties.Status.eq(0),
//                DiscountDao.Properties.Begin_time.le(currentTime),
//                DiscountDao.Properties.End_time.ge(currentTime))).list();
        return queryBuilder.where(DiscountDao.Properties.Status.eq(0)).list();
    }



}
