package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.FoodItemsModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.FoodItemsContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodItemsFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/29/2020 15:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = FoodItemsModule.class, dependencies = AppComponent.class)
public interface FoodItemsComponent {
    void inject(FoodItemsFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        FoodItemsComponent.Builder view(FoodItemsContract.View view);

        FoodItemsComponent.Builder appComponent(AppComponent appComponent);

        FoodItemsComponent build();
    }
}