package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.FoodSetModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.FoodSetContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodSetFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/29/2020 15:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = FoodSetModule.class, dependencies = AppComponent.class)
public interface FoodSetComponent {
    void inject(FoodSetFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        FoodSetComponent.Builder view(FoodSetContract.View view);

        FoodSetComponent.Builder appComponent(AppComponent appComponent);

        FoodSetComponent build();
    }
}