package com.joe.print.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.joe.print.di.module.PrintListModule;
import com.joe.print.mvp.contract.PrintListContract;

import com.jess.arms.di.scope.ActivityScope;
import com.joe.print.mvp.ui.activity.PrinterListActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/16/2020 10:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = PrintListModule.class, dependencies = AppComponent.class)
public interface PrintListComponent {
    void inject(PrinterListActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        PrintListComponent.Builder view(PrintListContract.View view);

        PrintListComponent.Builder appComponent(AppComponent appComponent);

        PrintListComponent build();
    }
}