package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.rengwuxian.materialedittext.MaterialEditText;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author : bin
 * @create date: 2020-10-31
 * @update date: 2020-10-31
 * @description:
 */
public class SkyOrderDialog extends Dialog {

    private static final String TAG = "SkyOrderDialog";

    private Activity mContext;

    @BindView(R2.id.cb_title)
    AppCompatCheckBox cbTitle;
    @BindView(R2.id.tv_start_time)
    TextView tvStartTime;
    @BindView(R2.id.tv_split)
    TextView tvSplit;
    @BindView(R2.id.tv_end_time)
    TextView tvEndTime;
    @BindView(R2.id.cl_time)
    ConstraintLayout clTime;
    @BindView(R2.id.rv_summary)
    RecyclerView rvSummary;
    @BindView(R2.id.tv_title)
    TextView tvTitle;
    @BindView(R2.id.ed_value)
    MaterialEditText edValue;
    @BindView(R2.id.btn_7)
    QMUIAlphaTextView btn7;
    @BindView(R2.id.btn_8)
    QMUIAlphaTextView btn8;
    @BindView(R2.id.btn_9)
    QMUIAlphaTextView btn9;
    @BindView(R2.id.tableRow1)
    TableRow tableRow1;
    @BindView(R2.id.btn_4)
    QMUIAlphaTextView btn4;
    @BindView(R2.id.btn_5)
    QMUIAlphaTextView btn5;
    @BindView(R2.id.btn_6)
    QMUIAlphaTextView btn6;
    @BindView(R2.id.tableRow2)
    TableRow tableRow2;
    @BindView(R2.id.btn_1)
    QMUIAlphaTextView btn1;
    @BindView(R2.id.btn_2)
    QMUIAlphaTextView btn2;
    @BindView(R2.id.btn_3)
    QMUIAlphaTextView btn3;
    @BindView(R2.id.tableRow3)
    TableRow tableRow3;
    @BindView(R2.id.btn_more)
    QMUIAlphaTextView btnMore;
    @BindView(R2.id.btn_0)
    QMUIAlphaTextView btn0;
    @BindView(R2.id.btn_clear)
    QMUIAlphaTextView btnClear;
    @BindView(R2.id.tableRow4)
    TableRow tableRow4;
    @BindView(R2.id.LL_keys)
    TableLayout LLKeys;
    @BindView(R2.id.btn_cha)
    QMUIAlphaTextView btnCha;
    @BindView(R2.id.btn_sure)
    QMUIAlphaTextView btnSure;


    // 动画时长
    private final static int mAnimationDuration = 300;
    // 持有 ContentView，为了做动画
    private View mContentView;
    private boolean mIsAnimating = false;

    public SkyOrderDialog(Activity context) {
        super(context, R.style.QMUI_BottomSheet);
        this.mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //noinspection ConstantConditions
        getWindow().getDecorView().setPadding(0, 0, 0, 0);

        // 在底部，宽度撑满
        WindowManager.LayoutParams params = getWindow().getAttributes();
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        params.gravity = Gravity.BOTTOM | Gravity.CENTER;

        int screenWidth = QMUIDisplayHelper.getScreenWidth(getContext());
        int screenHeight = QMUIDisplayHelper.getScreenHeight(getContext());
        params.width = screenWidth < screenHeight ? screenWidth : screenHeight;
        getWindow().setAttributes(params);
        setCanceledOnTouchOutside(false);
    }

    @Override
    public void setContentView(int layoutResID) {
        mContentView = LayoutInflater.from(getContext()).inflate(layoutResID, null);
        super.setContentView(mContentView);
    }

    @Override
    public void setContentView(@NonNull View view, ViewGroup.LayoutParams params) {
        mContentView = view;
        super.setContentView(view, params);
    }

    public View getContentView() {
        return mContentView;
    }

    @Override
    public void setContentView(@NonNull View view) {
        mContentView = view;
        super.setContentView(view);
    }

    /**
     * BottomSheet升起动画
     */
    private void animateUp() {
        if (mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, 1f, Animation.RELATIVE_TO_SELF, 0f
        );
        AlphaAnimation alpha = new AlphaAnimation(0, 1);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation(translate);
        set.addAnimation(alpha);
        set.setInterpolator(new DecelerateInterpolator());
        set.setDuration(mAnimationDuration);
        set.setFillAfter(true);
        mContentView.startAnimation(set);
    }

    /**
     * BottomSheet降下动画
     */
    private void animateDown() {
        if (mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 1f
        );
        AlphaAnimation alpha = new AlphaAnimation(1, 0);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation(translate);
        set.addAnimation(alpha);
        set.setInterpolator(new DecelerateInterpolator());
        set.setDuration(mAnimationDuration);
        set.setFillAfter(true);
        set.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                mIsAnimating = true;
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                mIsAnimating = false;
                /**
                 * Bugfix： Attempting to destroy the window while drawing!
                 */
                mContentView.post(new Runnable() {
                    @Override
                    public void run() {
                        // java.lang.IllegalArgumentException: View=com.android.internal.policy.PhoneWindow$DecorView{22dbf5b V.E...... R......D 0,0-1080,1083} not attached to window manager
                        // 在dismiss的时候可能已经detach了，简单try-catch一下
                        try {
                            SkyOrderDialog.super.dismiss();
                        } catch (Exception e) {
                            QMUILog.w(TAG, "dismiss error\n" + Log.getStackTraceString(e));
                        }
                    }
                });
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        mContentView.startAnimation(set);
    }

    @Override
    public void show() {
        super.show();
        animateUp();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (mIsAnimating) {
            return;
        }
        animateDown();
    }

    public SkyOrderDialog build() {
        View contentView = buildViews();
        setContentView(contentView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.7)));
        return this;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        ButterKnife.bind(view);
        return view;
    }




    protected int getContentViewLayoutId() {
        return R.layout.table_dialog_skyorder;
    }

}
