package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.elegant.bin.gsa.R;
import com.elegant.bin.gsa.app.payment.PayConstant;
import com.elegant.bin.gsa.app.utils.LanguageUtils;
import com.elegant.bin.gsa.mvp.main.ui.widget.customstatus.CustomStatusView;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.ThirdViewUtil;

import butterknife.BindView;


public class StatusLoadingDialog {

    private Activity mContext;
    private Dialog dialog;

    @BindView(R.id.ll_container)
    LinearLayout ll_container;

    @BindView(R.id.as_status)
    CustomStatusView as_status;
    @BindView(R.id.tv_status)
    TextView tv_status;

    //操作类型：1、支付  2、退款
    public static final int SALE_LOADING = 1;
    public static final int REFUND_LOADING = 2;
    public static final int VOID_LOADING = 3;
    private int opeatType = SALE_LOADING;

    private String loadingText;

    public StatusLoadingDialog(Activity context) {
        this.mContext = context;
        this.loadingText = LanguageUtils.get_language_system(mContext, "pay", "支付");

        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(mContext).inflate(R.layout.dialog_pay_loading, null);
        ThirdViewUtil.bindTarget(this, view);

        // 定义Dialog布局和参数
        dialog = new Dialog(mContext, R.style.loading_dialog);
        dialog.setContentView(view);
        dialog.setCancelable(false);

        ll_container.setLayoutParams(new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.4), (int) (ArmsUtils.getScreenWidth(mContext) * 0.4)));
    }

    public StatusLoadingDialog builder() {
        return this;
    }


    public void loadLoading() {
        as_status.loadLoading();
    }

    public void loadSuccess() {
        setStatusText(loadingText + LanguageUtils.get_language_system(mContext, "success", "成功"));
        as_status.loadSuccess();
        as_status.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (mOnClickListener != null) {
                    mOnClickListener.loadSuccessEnd();
                }
                cancel();
            }
        }, 1000);
    }

    public void loadFailure(String stauts) {
        switch (stauts) {
            case "100"://生成訂單失敗
                setStatusText(LanguageUtils.get_language_system(mContext, "generate.order.failed", "生成訂單失敗"));
                break;
            //N5支付返回狀態
            case PayConstant.PAY_STATUS_03:
                setStatusText(LanguageUtils.get_language_system(mContext, "confirm.or.handle", "确认/处理"));
                break;
            case PayConstant.PAY_STATUS_09:
                setStatusText(LanguageUtils.get_language_system(mContext, "cancelled", "已取消"));
                break;
            case PayConstant.PAY_STATUS_10:
                setStatusText(LanguageUtils.get_language_system(mContext, "moderator.rejected", "主持人拒絕"));
                break;
            case PayConstant.PAY_STATUS_11:
                setStatusText(LanguageUtils.get_language_system(mContext, "revoked", "已撤銷"));
                break;
            case PayConstant.PAY_STATUS_12:
                setStatusText(LanguageUtils.get_language_system(mContext, "transaction.has.been.cancelled.or.completed", "交易有已经作废/已完成"));
                break;
            case PayConstant.PAY_STATUS_13:
                setStatusText(LanguageUtils.get_language_system(mContext,"no.related.orders.found","找不到相關訂單"));
                break;
            case PayConstant.PAY_STATUS_90: //交易通訊格式有誤
            case PayConstant.PAY_STATUS_91: //功能或 付款方式没有 支持的
            case PayConstant.PAY_STATUS_99://未知错误
                setStatusText(loadingText + LanguageUtils.get_language_system(mContext,"failed","失敗"));
                break;
            case PayConstant.PAY_STATUS_98:
                switch (opeatType) {
                    case SALE_LOADING:
                        setStatusText(LanguageUtils.get_language_system(mContext, "prompt.payment request.timed.out", "支付請求超時"));
                        break;
                    case REFUND_LOADING:
                        setStatusText(loadingText + LanguageUtils.get_language_system(mContext,"timeout","超時"));
                        break;
                    case VOID_LOADING:
                        setStatusText(LanguageUtils.get_language_system(mContext, "rompt.void request.timed.out", "取消請求超時"));
                        break;
                }
                break;
            case PayConstant.PAY_STATUS_200:
                setStatusText(loadingText);
                break;
            default:
                setStatusText(loadingText + LanguageUtils.get_language_system(mContext,"success","成功"));
                break;
        }
        as_status.loadFailure();
        as_status.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (mOnClickListener != null) {
                    mOnClickListener.loadFailureEnd();
                }
                cancel();
            }
        }, 1000);
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public void setOpeatType(int opeatType) {
        this.opeatType = opeatType;
    }

    public void setStatusText(String text) {
        tv_status.setText(text);
    }

    public void clearLoadingAnim() {
        if (as_status != null && as_status.getAnimation() != null) {
            as_status.clearAnimation();
        }
    }

    public void show() {
        if (dialog != null)
            dialog.show();
        loadLoading();
    }

    public void cancel() {
        clearLoadingAnim();
        if (dialog != null && dialog.isShowing())
            dialog.cancel();
    }

    private OnLoadStautsListener mOnClickListener;

    public void setOnLoadStautsListener(OnLoadStautsListener onClickListener) {
        mOnClickListener = onClickListener;
    }

    public interface OnLoadStautsListener {

        void loadSuccessEnd();

        void loadFailureEnd();
    }
}
