package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Combo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.greendao.ComboDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.ModifierDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class ModifierDaoUtils {

    private static final String TAG = ModifierDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public ModifierDaoUtils(Context context){
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     * @param modifier
     * @return
     */
    public boolean insertModifier(Modifier modifier){
        boolean flag = false;
        flag = mManager.getDaoSession().getModifierDao().insert(modifier) == -1 ? false : true;
        Log.i(TAG, "insert Modifier :" + flag + "-->" + modifier.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param foodList
     * @return
     */
    public boolean insertMultModifier(final List<Modifier> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Modifier Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param modifier
     * @return
     */
    public boolean updateModifier(Modifier modifier){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(modifier);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param modifier
     * @return
     */
    public boolean deleteModifier(Modifier modifier){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(modifier);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Modifier.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<Modifier> queryAllModifier(){
        return mManager.getDaoSession().loadAll(Modifier.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public Modifier queryModifierById(long key){
        return mManager.getDaoSession().load(Modifier.class, key);
    }


    /**
     * 使用native sql进行查询操作
     */
    public List<Modifier> queryModifierByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(Modifier.class, sql, conditions);
    }


    /**
     * 使用queryBuilder进行查询食品
     * @return
     */
    public Modifier queryModifierByQueryBuilder(long mid){
        QueryBuilder<Modifier> queryBuilder = mManager.getDaoSession().queryBuilder(Modifier.class);
        return queryBuilder.where(ModifierDao.Properties.Mid.eq(mid)).build().unique();
    }

    /**
     * 使用queryBuilder进行查询食品
     * @param mid
     * @return
     */
    public List<Modifier> queryModifierByMidIdQueryBuilder(long mid) {
        QueryBuilder<Modifier> queryBuilder = mManager.getDaoSession().queryBuilder(Modifier.class);
        return queryBuilder.where(ModifierDao.Properties.Mid.eq(mid)).list();
    }

    /**
     * 使用queryBuilder进行查询食品
     * @param mod_msg
     * @param visible
     * @return
     */
    public List<Modifier> queryModifierByModMsgAndVisibleQueryBuilder(String mod_msg,int visible) {
        QueryBuilder<Modifier> queryBuilder = mManager.getDaoSession().queryBuilder(Modifier.class);
        return queryBuilder.where(ModifierDao.Properties.ModMsg.eq(mod_msg)).where(ModifierDao.Properties.Invisible.eq(visible)).list();
    }


    /**
     * 使用queryBuilder进行查询食品
     * @param mod_taste
     * @param visible
     * @return
     */
    public List<Modifier> queryModifierByModModTasteVisibleQueryBuilder(long mod_taste,int visible) {
        QueryBuilder<Modifier> queryBuilder = mManager.getDaoSession().queryBuilder(Modifier.class);
        return queryBuilder.where(ModifierDao.Properties.ModTaste.eq(mod_taste)).where(ModifierDao.Properties.Invisible.eq(visible)).list();
    }

    /**
     * 使用queryBuilder进行查询食品
     * @param topid
     * @param visible
     * @return
     */
    public List<Modifier> queryModifierByTopidAndVisibleQueryBuilder(long topid,int visible) {
        QueryBuilder<Modifier> queryBuilder = mManager.getDaoSession().queryBuilder(Modifier.class);
        return queryBuilder.where(ModifierDao.Properties.TopId.eq(topid)).where(ModifierDao.Properties.Invisible.eq(visible)).list();
    }
}
