package com.gingersoft.gsa.cloud.table.app.payment.callback;

import android.app.Activity;
import android.content.Context;
import android.util.Log;

import com.elvishew.xlog.XLog;
import com.etps.aca.lib.action.ICommand;
import com.etps.aca.lib.constant.Constant;
import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.table.app.payment.N5CallbackManage;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.OrderPayActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.integration.AppManager;
import com.jess.arms.utils.ArmsUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CommandImpl implements ICommand {

    private static final String TAG = CommandImpl.class.getSimpleName();

    @Override
    public void onRequest(Context context, String request) {

        XLog.tag(TAG).d("onRequest : " + request);

        try {
            JSONObject msgObj = new JSONObject(request);
            String eventName = msgObj.getString(Constant.EVENT.ATTR.EVENT_NAME);
//            if (Constant.EVENT.NAME.SALE.equals(eventName)) {
//                Intent intent = new Intent(context, LoginActivity.class);
//                intent.setAction("SALE");
//                context.startActivity(intent);
//            } else if (Constant.EVENT.NAME.REFUND.equals(eventName)) {
//                Intent intent = new Intent(context, LoginActivity.class);
//                context.startActivity(intent);
//            } else if (Constant.EVENT.NAME.VOID.equals(eventName)) {
//                Intent intent = new Intent(context, LoginActivity.class);
//                context.startActivity(intent);
//            } else if (Constant.EVENT.NAME.GOTO.equals(eventName)) {
//                Intent intent = new Intent(context, LoginActivity.class);
//                context.startActivity(intent);
//            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /**
     * 支付失败 {"EVENT_NAME":"SALE_RESP","STATUS":"09","TXN_ID":"20171205153245643043436585106024","TXN_AMT":1,"TIPS":0.00}
     * 支付成功 {"EVENT_NAME":"SALE_RESP","MID":"181500000260","PAYMENT_TYPE":"WCP","TRACE_NO":"20171205153245643043436585122154","RESP_CODE":"F0000","TIPS":0,"HOST_REF":"4200000136201805303582803320","TXN_TIME":"162530","TXN_DATE":"20181116","TXN_ID":"20171205153245643043436585122154","STATUS":"00","TID":"12189001","TXN_AMT":0.10}
     * 取消成功 {"EVENT_NAME":"VOID_RESP","STATUS":"00","PAYMENT_TYPE":"UP","RESP_CODE":"C1000","HOST_REF":"729706000007","TXN_TIME":"175305","TXN_ID":"PAY201911011747001513","TXN_DATE":"20191101"}
     */
    @Override
    public void onResponse(Context context, String response) {

        XLog.tag(TAG).d("onResponse : " + response);

        try {
            JSONObject msgObj = new JSONObject(response);
            String eventName = msgObj.getString(Constant.EVENT.ATTR.EVENT_NAME);

            AppComponent appComponent = ArmsUtils.obtainAppComponentFromContext(context);
            AppManager appManager = appComponent.appManager();

//            Activity currentActivity = appManager.getCurrentActivity();
            Activity currentActivity = null;
            if (appManager.getActivityList() != null && appManager.getActivityList().size() > 0) {
                currentActivity = appManager.getActivityList().get(appManager.getActivityList().size() - 2);
            }

            Log.i(TAG, "currentActivity: " + currentActivity.getClass().getName());

            switch (eventName) {
                case Constant.EVENT.NAME.SALE_RESP:
//                    N5CallbackManage.getInstance().post(currentActivity, response, Constant.EVENT.NAME.SALE_RESP);
                    appManager.killActivity(currentActivity.getClass());
                    OrderPayActivity.startOrderPayActivityFormSale(context, response);
                    break;
                case Constant.EVENT.NAME.VOID_RESP:
                    N5CallbackManage.getInstance().post(currentActivity, response, Constant.EVENT.NAME.VOID_RESP);
                    break;
                case Constant.EVENT.NAME.REFUND_RESP:
//                    N5CallbackManage.getInstance().post(currentActivity, response, Constant.EVENT.NAME.REFUND_RESP);
                    appManager.killActivity(currentActivity.getClass());
//                    if (currentActivity.getClass().getName().equals(OrderDetailActivity.class.getName())) {
//                        OrderDetailActivity.startOrderDetailActivityFormRefund(context, response);
//                    } else {
//                        OrderManagementActivity.startOrderManageActivityFormRefund(context, response);
//                    }
                    break;
                case Constant.EVENT.NAME.PRINT_RESP:
                    N5CallbackManage.getInstance().post(currentActivity, response, Constant.EVENT.NAME.PRINT_RESP);
                    break;
                case Constant.EVENT.NAME.ADJUST_RESP:
                    N5CallbackManage.getInstance().post(currentActivity, response, Constant.EVENT.NAME.ADJUST_RESP);
                    break;
                case "RETRIEVAL_RESP":
                    N5CallbackManage.getInstance().post(currentActivity, response, "RETRIEVAL_RESP");
                    break;
                case "SETTLE_RESP":
                    N5CallbackManage.getInstance().post(currentActivity, response, "SETTLE_RESP");
                    break;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onGoto(Context context) {
        LogUtil.d(TAG, "onGoto");
    }


}
