package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

import java.util.List;

import androidx.recyclerview.widget.GridLayoutManager;
import butterknife.BindView;

public class HorizontalGridViewAdpter extends BaseAdapter {

    private Context mContext;
    private List<Food> lists;//数据源
    private int mIndex; // 页数下标，标示第几页，从0开始
    private int mPargerSize;// 每页显示的最大的数量

    private int mOrderNumberShowSize;
    private int mOrderNumberFontSize;
    private int FoodTypeFontSize;

    private int mParentRowCount;
    private int mParentColWidth;
    private int mParentColHeight;
    private int mLayoutQtyHeight;

    private int currentSelectPosition;

    public HorizontalGridViewAdpter(Context context, List<Food> lists, int mIndex, int mPargerSize) {
        this.mContext = context;
        this.lists = lists;
        this.mIndex = mIndex;
        this.mPargerSize = mPargerSize;

        this.mOrderNumberShowSize = GsaCloudApplication.androidSetting.getOrderNumberShowSize();
        this.mOrderNumberFontSize = GsaCloudApplication.androidSetting.getOrderNumberFontSize();
        this.FoodTypeFontSize = GsaCloudApplication.androidSetting.getFoodTypeFontSize();
        int foodCol = GsaCloudApplication.androidSetting.getFoodTypeCol();
        this.mParentColWidth = (int) (DeviceUtils.getScreenWidth(context) / foodCol);
        this.mParentColHeight = GsaCloudApplication.androidSetting.getLayoutFoodTypeHeight() / GsaCloudApplication.androidSetting.getFoodTypeRow();
        this.mLayoutQtyHeight = GsaCloudApplication.androidSetting.getLayoutQtyHeight();
    }

    /**
     * 先判断数据及的大小是否显示满本页lists.size() > (mIndex + 1)*mPagerSize
     * 如果满足，则此页就显示最大数量lists的个数
     * 如果不够显示每页的最大数量，那么剩下几个就显示几个
     */
    @Override
    public int getCount() {
        return lists.size() > (mIndex + 1) * mPargerSize ?
                mPargerSize : (lists.size() - mIndex * mPargerSize);
    }

    @Override
    public Food getItem(int arg0) {
        return lists.get(arg0 + mIndex * mPargerSize);
    }

    @Override
    public long getItemId(int arg0) {
        return arg0 + mIndex * mPargerSize;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        //重新确定position因为拿到的总是数据源，数据源是分页加载到每页的GridView上的
        final int pos = position + mIndex * mPargerSize;//假设mPageSiez
        Food food = lists.get(pos);

        final ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = View.inflate(mContext, R.layout.meal_item_food_group, null);
            holder.tv_name = convertView.findViewById(R.id.tv_name);
            holder.tv_number = convertView.findViewById(R.id.tv_number);
            holder.tv_soldout = convertView.findViewById(R.id.tv_soldout);
            holder.rl_container = convertView.findViewById(R.id.rl_container);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        setFoodGroup(holder, food);
        setNumber(holder, food);
        setSoldoutStatus(holder, food);

        //假设mPagerSize=8，假如点击的是第二页（即mIndex=1）上的第二个位置item(position=1),那么这个item的实际位置就是pos=9
        holder.tv_name.setText(lists.get(pos).getFoodName());
        holder.tv_name.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                Food food = lists.get(pos);

                for (int i = 0; i < lists.size(); i++) {
                    lists.get(i).setSelected(false);
                }
                lists.get(pos).setSelected(true);

                if (mOnItemClickListener != null)
                    mOnItemClickListener.onItemClick(food, pos);

                notifyDataSetChanged();
            }
        });
        return convertView;
    }

    public void setFoodGroup(ViewHolder holder, Food datasBean) {
//        holder.tv_name.setMaxHeight(50);
//        holder.tv_name.setMinHeight(50);
//        holder.tv_name.setHeight(50);
//
//        holder.tv_name.setMaxWidth(mParentColWidth);
//        holder.tv_name.setMinWidth(mParentColWidth);
//        holder.tv_name.setWidth(mParentColWidth);

        holder.tv_name.setText(datasBean.getFoodName());
        holder.tv_name.setTextSize(FoodTypeFontSize);
//        holder.tv_name.setHeight(mParentColHeight);
        holder.tv_name.setGravity(Gravity.CENTER);

        holder.rl_container.setLayoutParams(new RelativeLayout.LayoutParams(
                mParentColWidth,
                mParentColHeight));

        //后台没有设置颜色当前选中高亮色,没有选中默认使用绿色
        if (datasBean.isSelected()) {
            holder.tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.orange_500));
            holder.tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
        } else {
            holder.tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
            holder.tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
        }
    }

    public void setNumber(ViewHolder holder, Food datasBean) {
        holder.tv_number.setTextSize(10);
        holder.tv_number.setHeight(mLayoutQtyHeight);

        ViewGroup.MarginLayoutParams mp = new ViewGroup.MarginLayoutParams(mOrderNumberShowSize, mOrderNumberShowSize);  //item�Ŀ��
        mp.setMargins(0, 0, 0, 0);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(mp);
        lp.width = ArmsUtils.dip2px(mContext, 16);
        lp.height = ArmsUtils.dip2px(mContext, 16);
        holder.tv_number.setLayoutParams(lp);

        if (datasBean.getNumber() == 0) {
            holder.tv_number.setVisibility(View.INVISIBLE);
        } else {
            holder.tv_number.setVisibility(View.VISIBLE);
            holder.tv_number.setText(datasBean.getNumber() + "");
        }
    }

    public void setSoldoutStatus(ViewHolder holder, Food datasBean) {
        holder.tv_soldout.setMaxHeight(mOrderNumberShowSize);
        holder.tv_soldout.setMinHeight(mOrderNumberShowSize);
        holder.tv_soldout.setTextSize(mOrderNumberFontSize);

//            String qty = datasBean.getOR_Qty();
//            if (TextUtils.isEmpty(qty)) {
//                tv_soldout.setVisibility(View.INVISIBLE);
//            } else {
//                tv_soldout.setVisibility(View.VISIBLE);
//        holder.tv_soldout.setText(datasBean.getNumber());
//            }
    }

    static class ViewHolder {
        private TextView tv_name, tv_number, tv_soldout;
        private RelativeLayout rl_container;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Food food, int position);

    }
}
