package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem5;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindViews;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class SettlementReportItem5Adapter extends DefaultAdapter<SectionTextItem5> {

    private Context mContext;
    private int textSize;
    public SettlementReportItem5Adapter(Context context, List<SectionTextItem5> infos) {
        super(infos);
        this.mContext = context;
        textSize = 16;
    }

    public SettlementReportItem5Adapter(Context context, List<SectionTextItem5> infos, int textSize) {
        super(infos);
        this.mContext = context;
        this.textSize = textSize;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<SectionTextItem5> getHolder(View v, int viewType) {
        return new SettlementReportItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_settlement_report5;
    }

    class SettlementReportItemHolder extends BaseHolder<SectionTextItem5> {

        @BindViews({R2.id.tv_item1, R2.id.tv_item2, R2.id.tv_item3, R2.id.tv_item4, R2.id.tv_item5})
        TextView[] tv_items;

        public SettlementReportItemHolder(View itemView) {
            super(itemView);
            for (int i = 0; i < tv_items.length; i++) {
                tv_items[i].setTextSize(textSize);
            }
        }

        @Override
        public void setData(SectionTextItem5 reportItem, int position) {
            if (!TextUtils.isEmpty(reportItem.getItem1())) {
                tv_items[0].setText(reportItem.getItem1());
                tv_items[0].setVisibility(View.VISIBLE);
            } else {
                tv_items[0].setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(reportItem.getItem2())) {
                tv_items[1].setText(reportItem.getItem2());
                tv_items[1].setVisibility(View.VISIBLE);
            } else {
                tv_items[1].setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(reportItem.getItem3())) {
                tv_items[2].setText(reportItem.getItem3());
                tv_items[2].setVisibility(View.VISIBLE);
            } else {
                tv_items[2].setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(reportItem.getItem4())) {
                tv_items[3].setText(reportItem.getItem4());
                tv_items[3].setVisibility(View.VISIBLE);
            } else {
                tv_items[3].setVisibility(View.GONE);
            }

            if (!TextUtils.isEmpty(reportItem.getItem5())) {
                tv_items[4].setText(reportItem.getItem5());
                tv_items[4].setVisibility(View.VISIBLE);
            } else {
                tv_items[4].setVisibility(View.GONE);
            }
        }
    }
}
