package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.constans.MealConstant;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.presenter.MealStandPresenter;
import com.gingersoft.gsa.cloud.table.mvp.presenter.OrderContentPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.MealStandActivity;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import butterknife.BindView;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/9/16
 * 修订历史：2018/9/17
 * 描述：
 */

public class SelectMealAdapter extends DefaultAdapter<OrderDetail> {

    private Context mContext;

    private MealStandActivity mMealStandActivity;
    private OrderContentPresenter mOrderContentPresenter;

    private int BillListFontSize = 18;
    private String carshStr = "$";

    private int mainStartPos = 0;
    private int mainEndPos = 0;

    private int select_position = -1;
    private int select_start_position = 0;
    private int select_end_position = 0;
    public int select_full_start_position = 0;
    public int select_full_end_position = 0;

    /**
     * 選中模式（1=單選，2=多選）
     */
    public static final int SINGLE_SELECTED = 1;
    public static final int MULTIPLE_SELECTED = 2;
    private int selectedMode = SINGLE_SELECTED;


    public SelectMealAdapter(Context context, List<OrderDetail> data, BasePresenter presenter) {
        super(data);
        this.mContext = context;
        this.BillListFontSize = GsaCloudApplication.uiStyleConfiguration.getBillListFontSizeValue();
        if (presenter instanceof MealStandPresenter) {
            this.mMealStandActivity = (MealStandActivity) context;
        } else if (presenter instanceof OrderContentPresenter) {
            this.mOrderContentPresenter = (OrderContentPresenter) presenter;
        }
    }

    @Override
    public int getItemCount() {
        return mInfos == null ? 0 : mInfos.size();
    }

    @Override
    public SelectMealItemHolder getHolder(View v, int viewType) {
        return new SelectMealItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_select_meal_stand;
    }

    class SelectMealItemHolder extends BaseHolder<OrderDetail> implements View.OnClickListener {

        @BindView(R2.id.rl_container)
        RelativeLayout rl_container;

        @BindView(R2.id.rl_select)
        RelativeLayout rl_select;
        @BindView(R2.id.ll_tvname)
        RelativeLayout ll_tvname;

        @BindView(R2.id.tv_number)
        TextView tv_number;
        @BindView(R2.id.tv_food_table_mode)
        TextView tv_food_table_mode;
        @BindView(R2.id.tv_modify_before_number)
        TextView tv_modify_before_number;
        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_money)
        TextView tv_money;

        @BindView(R2.id.tv_D)
        TextView tv_D;
        @BindView(R2.id.tv_S)
        TextView tv_S;
        @BindView(R2.id.tv_D_1)
        TextView tv_D_1;
        @BindView(R2.id.tv_S_1)
        TextView tv_S_1;

        @BindView(R2.id.tv_discount_money)
        TextView tv_discount_money;
        @BindView(R2.id.tv_mix)
        TextView tv_mix;

        @BindView(R2.id.iv_add_count)
        ImageView iv_add_count;
        @BindView(R2.id.iv_delete_count)
        ImageView iv_delete_count;

        public SelectMealItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void onClick(View view) {
            if (mOnItemClickListener != null) {
                int position = this.getPosition();
                if (position < mInfos.size()) {
                    if (selectedMode == MULTIPLE_SELECTED) {
                        if (mInfos.get(position).getSelected() != 0 && mInfos.get(position).getItemType() != 1) {
                            return;
                        }
                    }
                    setSelectPosition(position);
                    //设置当前选中的食品或食品组
                    mOnItemClickListener.onItemClick(mInfos.get(position), position);
                }
            }
        }

        @Override
        public void setData(OrderDetail datasBean, int position) {

            setViewVisibility(datasBean);
            if (datasBean.isVisible()) {
                rl_container.setVisibility(View.VISIBLE);
                setName(datasBean);
                setNumber(datasBean);
                setMoney(datasBean);
                setMealCountLayout(datasBean, position);
                setColor(datasBean);
                setTextSize();
            } else {
                rl_container.setVisibility(View.INVISIBLE);
            }
        }

        private void setViewVisibility(OrderDetail datasBean) {
            //是否参与折扣
            if (datasBean.getAblediscount() == 0) {
                tv_D.setVisibility(View.VISIBLE);
            } else {
                tv_D.setVisibility(View.INVISIBLE);
            }
            //是否参与服務費
            if (datasBean.getScAble() == 0) {
                tv_S.setVisibility(View.VISIBLE);
            } else {
                tv_S.setVisibility(View.INVISIBLE);
            }
            //是否可折上折
            if (datasBean.getType() != OrderDetail.DISCOUNT_TYPE && datasBean.getAdditionalDiscount() == 0) {
                tv_D_1.setVisibility(View.VISIBLE);
            } else {
                tv_D_1.setVisibility(View.INVISIBLE);
            }
            //使用此折扣是否可免服務費
            if (datasBean.getType() != OrderDetail.DISCOUNT_TYPE && datasBean.getFreeServiceCharge() == 1) {
                tv_S_1.setVisibility(View.VISIBLE);
            } else {
                tv_S_1.setVisibility(View.INVISIBLE);
            }

            tv_discount_money.setVisibility(View.INVISIBLE);

            if (datasBean.isModify()) {
                if (datasBean.getType() == OrderDetail.MODIFIER_TYPE) {
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) tv_number.getLayoutParams();
                    layoutParams.rightMargin = ArmsUtils.getDimens(mContext,R.dimen.dp_15);
                    tv_number.setLayoutParams(layoutParams);
                }
                tv_modify_before_number.setText(String.valueOf(datasBean.getModifyBeforeNumber()));
                tv_modify_before_number.setVisibility(View.VISIBLE);
            } else {
                tv_modify_before_number.setVisibility(View.INVISIBLE);
                if (datasBean.getType() == OrderDetail.MODIFIER_TYPE) {
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) tv_number.getLayoutParams();
                    layoutParams.rightMargin = 0;
                    tv_number.setLayoutParams(layoutParams);
                }
            }
        }

        private void setMealCountLayout(OrderDetail datasBean, int position) {
            if (datasBean.isNew() &&
                    mOrderContentPresenter != null &&
                    datasBean.getSelected() != 0 &&
                    datasBean.getProp() == OrderDetail.FOOD_PROP) {

                iv_add_count.setVisibility(View.VISIBLE);
                iv_delete_count.setVisibility(View.VISIBLE);
                iv_add_count.setOnClickListener(v -> {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onMealCountAdd(datasBean, position);
                    }
                });
                iv_delete_count.setOnClickListener(v -> {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onMealCountDelete(datasBean, position);
                    }
                });
            } else {
                iv_add_count.setVisibility(View.INVISIBLE);
                iv_delete_count.setVisibility(View.INVISIBLE);
            }
        }

        private void setName(OrderDetail datasBean) {
            int flevel = datasBean.getItemType();
            String name = datasBean.getProductName();
            switch (flevel) {
                case 1:
                    tv_number.setGravity(Gravity.LEFT);
                    break;
                case 2:
                    name = "  " + name;
                    tv_number.setGravity(Gravity.CENTER);
                    break;
                case 3:
                    name = "      " + name;
                    tv_number.setGravity(Gravity.RIGHT);
                    break;
            }
            tv_name.setText(name);

            int selected = datasBean.getSelected();
            if (selected != 0) {
                //作为主体被选中 开启跑马灯效果
                tv_name.setFocusable(true);
                tv_name.setEllipsize(TextUtils.TruncateAt.MARQUEE);//设置旋转
                tv_name.setMarqueeRepeatLimit(-1);//-1为死循环，1为1次
                tv_name.setSelected(true);//设置不获取焦点就可以转
                tv_name.setFocusableInTouchMode(true);
            } else {
                //关闭跑马灯效果
                tv_name.setFocusable(false);
                tv_name.setMarqueeRepeatLimit(0);
                tv_name.setSelected(false);
                tv_name.setFocusableInTouchMode(false);
            }
        }

        private void setNumber(OrderDetail datasBean) {
            int number = datasBean.getNumber();
            if (number == 0 || datasBean.getType() == OrderDetail.DISCOUNT_TYPE) {
                //细项、折扣不需要显示数量
                tv_number.setText("");
            } else {
                tv_number.setText(String.valueOf(number));
            }
        }

        private void setMoney(OrderDetail datasBean) {
            double price = datasBean.getPrice();
            if (price != 0) {
                if (datasBean.getType() == OrderDetail.DISCOUNT_TYPE) {
                    tv_money.setText("-" + carshStr + MoneyUtil.get_ItemDecimals_money(Math.abs(price)));
                } else {
                    tv_money.setText(carshStr + MoneyUtil.get_ItemDecimals_money(price));
                }
            } else {
                tv_money.setText("");
            }
        }

        private void setColor(OrderDetail datasBean) {
            int selected = datasBean.getSelected();
            switch (selected) {
                case 0:
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    ll_tvname.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    break;
                case 1:
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));// Color.YELLOW);
                    ll_tvname.setBackgroundResource(R.color.itemSelected);
                    break;
                case 2:
                case 3:
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));
                    ll_tvname.setBackgroundResource(R.color.mainSelected);
                    break;
            }
//            }
            //设置Item选中颜色
            if (datasBean.isNew() == false) {
                tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
                tv_number.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
                tv_money.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
            } else {
                tv_number.setTextColor(ArmsUtils.getColor(mContext, R.color.black));
                tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.black));
                tv_money.setTextColor(ArmsUtils.getColor(mContext, R.color.black));
            }

            if (datasBean.isModify()) {
                //数量为0  说明是修改订单  删除的食品，颜色设置了红色
                tv_name.setTextColor(ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.red_500));
            }
        }

        public void setTextSize() {
            tv_money.setTextSize(BillListFontSize);
            tv_name.setTextSize(BillListFontSize);
            tv_number.setTextSize(BillListFontSize);

            tv_D.setTextSize(BillListFontSize / 2);
            tv_S.setTextSize(BillListFontSize / 2);
            tv_D_1.setTextSize(BillListFontSize / 2);
            tv_S_1.setTextSize(BillListFontSize / 2);
        }
    }

    public int addFoodItem(OrderDetail datasBean) {
        int addPosition = addPositionItem(datasBean);
        setSelectPosition(select_position);
        setIndex();
        setItemNo(datasBean);
        return addPosition;
    }

    public int addPositionItem(OrderDetail addFoodBean) {

        int addPosition = select_position;
        boolean upAdd = true;

        switch (addFoodBean.getItemType()) {
            case 1:
                addPosition = select_position = mInfos.size();
                break;
            case 2:
                addPosition = select_full_end_position + 1;
                break;
            case 3:
                if (mInfos.get(select_position).getItemType() == 3) {
                    addPosition = select_end_position + 1;
                    select_position = addPosition;
                } else {
                    switch (mInfos.get(select_position).getItemType()) {
                        case 1:
                            if (hasChild3Food(mInfos.get(select_position))) {
                                addPosition = select_end_position + 1;
                            } else {
                                addPosition = select_position + 1;
                                upAdd = false;
                            }
                            break;
                        case 2:
                            if (hasChildFood(mInfos.get(select_position))) {
                                addPosition = select_end_position + 1;
                            } else {
                                addPosition = select_position + 1;
                                upAdd = false;
                            }
                            break;
                        case 3:
                            int edgeIndex2 = getChild2EdgeIndex();
                            addPosition = edgeIndex2 + 1;
                            select_position = addPosition;
                            break;
                    }
                }
                break;
        }
        boolean hasFoodDiscount = OrderDetail.hasFoodDiscount(mInfos, select_full_start_position, select_full_end_position);
        if (addPosition >= mInfos.size()) {
            if (addFoodBean.getType() != OrderDetail.DISCOUNT_TYPE && hasFoodDiscount && addFoodBean.getItemType() != 1 && upAdd) {
                //子食品添加到折扣上面
                addPosition = mInfos.size() - 1;
                mInfos.add(addPosition, addFoodBean);
            } else {
                mInfos.add(addFoodBean);
            }
        } else {
            if (addFoodBean.getType() != OrderDetail.DISCOUNT_TYPE && hasFoodDiscount && addFoodBean.getItemType() != 1 && upAdd) {
                //子食品添加到折扣上面
                addPosition -= 1;
            }
            mInfos.add(addPosition, addFoodBean);
        }
        return addPosition;
    }

    /**
     * 長按刪除食品
     */
    public void removeAllNewFoodItem() {
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            OrderDetail orderItem = mInfos.get(i);
            if (orderItem != null && orderItem.isNew()) {
                mInfos.remove(i);
                notifyItemChanged(i);
//                Food orderBean = mMealStandPresenter.getFoodByFid(orderItem.getId());
//                if (orderBean != null) {
//                    mMealStandPresenter.setFoodMaxQty(orderBean);
//                }
            }
        }

        if (mInfos.size() == 0) {
            //全部刪除
            return;
        }

        setIndex();

        setSelectPosition(select_position);

        mMealStandActivity.showViewModeVisibility(MealConstant.food_group_ViewMode, MealConstant.food_ViewMode);
    }

    /**
     * 根據下標刪除對應食品
     *
     * @param position
     */
    public void removeItemByPosition(int position) {
        if (mInfos.size() > position) {
            mInfos.remove(position);
            notifyItemChanged(position);
        }
        if (mInfos.size() == 0) {
            //全部删除重置选中下标
            select_position = -1;
        } else {
            if (select_position == mInfos.size()) {
                select_position -= 1;
            }
        }

        setIndex();
        setSelectPosition(select_position);
    }

    /**
     * 删除食品
     */
    public int removeFoodItem() {

        removeIntactFoodItem();

        if (mInfos.size() == 0) {
            //全部删除重置选中下标
            select_position = -1;
        } else {
            if (select_position == mInfos.size()) {
                select_position -= 1;
            }
        }

        setIndex();

        setSelectPosition(select_position);

        if (mMealStandActivity != null) {
            mMealStandActivity.showViewModeVisibility(MealConstant.food_group_ViewMode, MealConstant.food_ViewMode);
        }
        return select_position;
    }

    /**
     * 删除食品子项及折扣
     */
    public void removeChildItem() {
        OrderDetail orderDetail = mInfos.get(select_position);
        if (select_position > -1) {
            switch (orderDetail.getItemType()) {
                case 1:
                    //第一层下方有细项 从下方往上删
                    if (select_full_end_position != 0 && select_full_end_position > select_position) {
                        for (int i = select_full_end_position; i > select_position; i--) {
                            OrderDetail orderBean = mInfos.get(i);
                            boolean isParentChild = orderBean.getParentIndex() == orderDetail.getMyIndex();
                            if (orderBean.isNew()) {
                                if (orderBean.getItemType() == 2 && !isParentChild) {
                                    //第二层下面有第三层子项也要一并删除
                                    removeAllChild3ByCombo(orderBean);
                                } else {
                                    mInfos.remove(i);
                                    notifyItemChanged(i);
                                }
                                break;
                            }
                        }
                    } else {
                        //第一层没有子食品 直接退出
                        return;
                    }
                    break;
                case 2:
                    if (select_end_position != 0 &&
                            select_end_position > select_position &&
                            hasChild3Food(orderDetail)) {
                        //第二层 下面有第三层子项也要一并删除
                        for (int i = select_end_position; i >= select_position; i--) {
                            if (mInfos.get(i).isNew()) {
                                mInfos.remove(i);
                                notifyItemChanged(i);
                                break;
                            }
                        }
                    } else {
                        if (mInfos.get(select_position).isNew()) {
                            mInfos.remove(select_position);
                            notifyItemChanged(select_position);
                        }
                    }
                    break;
                case 3:
                    if (mInfos.get(select_position).isNew()) {
                        mInfos.remove(select_position);
                        notifyItemChanged(select_position);
                    }
                    break;
            }
        }

        if (select_position >= mInfos.size()) {
            select_position = mInfos.size() - 1;
        }

        if (mInfos.size() == 0) {
            //全部删除重置选中下标
            select_position = -1;
        } else {
            switch (orderDetail.getItemType()) {
                case 1:
                    break;
                case 2:
                    int comboIndex = getComboEdgeIndex();
                    if (comboIndex != (orderDetail.getMyIndex() - 1)) {
                        select_position -= 1;
                    } else {
                        if (select_position == mInfos.size()) {
                            select_position -= 1;
                        }
                    }
                    break;
                case 3:
                    int edgeIndex = getChild2EdgeIndex();
                    if (edgeIndex != (orderDetail.getMyIndex() - 1)) {
                        select_position -= 1;
                    } else {
                        if (select_position == mInfos.size()) {
                            select_position -= 1;
                        }
                    }
                    break;
            }
        }
        setIndex();
        setSelectPosition(select_position);
    }

    private void removeIntactFoodItem() {
        int start_position = select_full_start_position + 1;
        int end_position = select_full_end_position + 1;
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            int my_index = mInfos.get(i).getMyIndex();
            if (start_position <= my_index && my_index <= end_position) {
                if (mInfos.get(i).isNew()) {
                    mInfos.remove(i);
                    notifyItemChanged(i);
                }
            }
        }
    }

    /**
     * 删除第二层子食品下所有第三层备注
     *
     * @param orderDetail
     * @return
     */
    private boolean removeAllChild3ByCombo(OrderDetail orderDetail) {
        boolean remove = false;
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            boolean accordChild3 = mInfos.get(i).getParentIndex() == orderDetail.getParentIndex() || mInfos.get(i).getMyIndex() == orderDetail.getParentIndex();
            if (mInfos.get(i).getItemType() == 3 && accordChild3) {
                mInfos.remove(i);
                notifyItemChanged(i);
                remove = true;
            }
        }
        return remove;
    }

    /**
     * 获取食品第细项最后一个子项位置
     *
     * @return
     */
    private int getChild2EdgeIndex() {
        int parent_index = getParentFoodIndex(mInfos.get(select_position));
        int edgeIndex = parent_index;
        for (int i = 0; i < mInfos.size(); i++) {
            OrderDetail datasBean = mInfos.get(i);
            if (datasBean.getItemType() == 3 && datasBean.getParentIndex() == parent_index) {
                edgeIndex = i;
            }
        }
        return edgeIndex;
    }

    /**
     * 是否包含第三層細項
     *
     * @param orderDetail
     * @return
     */
    private boolean hasChild3Food(OrderDetail orderDetail) {
        if (orderDetail.getItemType() == 3) {
            return false;
        }
        for (int i = 0; i < mInfos.size(); i++) {
            if (mInfos.get(i).getItemType() == 3 && mInfos.get(i).getParentIndex() == orderDetail.getMyIndex()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasChildFood(OrderDetail orderDetail) {
        if (orderDetail.getItemType() == 3) {
            return false;
        }
        for (int i = 0; i < mInfos.size(); i++) {
            if (mInfos.get(i).getParentIndex() == orderDetail.getMyIndex()) {
                return true;
            }
        }
        return false;
    }

    private int getParentFoodIndex(OrderDetail foodBean) {
        int parent_index = 0;
        if (foodBean.getItemType() == 1) {
            parent_index = foodBean.getMyIndex();
        } else {
            parent_index = foodBean.getParentIndex();
        }
        return parent_index;
    }

    private void setItemNo(OrderDetail foodBean) {
//        switch (foodBean.getItemType()) {
//            case 1:
////                foodBean.setTopId(foodBean.getProductId());
//                break;
//            case 2:
//            case 3:
//                long itemno = -1;
//                if (select_position != -1 && select_position < mInfos.size()) {
//                    if (mInfos.get(select_position).isIsfood()) {
//                        itemno = mInfos.get(select_position).getProductId();
//                    } else {
//                        if (select_start_position != -1 && select_start_position < mInfos.size()) {
//                            itemno = mInfos.get(select_start_position).getProductId();
//                        }
//                    }
//                }
//                foodBean.setTopId(itemno);
//                break;
//            default:
//                break;
//        }
    }

    /**
     * 设置关联父子项Index
     */
    public void setIndex() {
        // 调整myorder中的parent_index及my_index
        int parent_index = 0;
        int my_index = 0;
        int my_index2 = 0;
        int t = 0;
        // 调整myorder中的顺序位
        // 获取旧项目的最后的seqno不是新项目开始
        int iseqno = 1;
        int isseq = 0;
        int imseq = 0;
        for (int i = 0; i < mInfos.size(); i++) {
            OrderDetail myorder = mInfos.get(i);
            t = t + 1;
            if (myorder != null) {
                switch (myorder.getItemType()) {
                    case 1:
                        parent_index = parent_index + 1;
                        my_index = t;
                        my_index2 = t;
                        myorder.setParentIndex(0);
                        myorder.setMyIndex(t);
                        break;
                    case 2:
                        myorder.setParentIndex(my_index);
                        myorder.setMyIndex(t);
                        my_index2 = t;
                        break;
                    case 3:
                        myorder.setParentIndex(my_index2);
                        myorder.setMyIndex(t);
                        break;
                }
            }
        }
    }

    public void setSelectPosition(int position) {

        if (position == -1)
            return;

        select_position = position;

        int startPos = select_position;
        int endPos = select_position;

        mainStartPos = startPos;
        mainEndPos = endPos;

        if (select_position >= mInfos.size()) {
            select_position = mInfos.size() - 1;
        }
        OrderDetail myorder = mInfos.get(select_position);

        int k = select_position;
        select_full_start_position = k;

        OrderDetail checkOrder = mInfos.get(k);
        while (checkOrder.getItemType() != 1) {
            // checkOrder.selected=3;
            select_full_start_position = k;
            k = k - 1;
            if (k > -1) {
                checkOrder = mInfos.get(k);
                if (checkOrder.getItemType() == 1) {
                    // checkOrder.selected=3;
                    select_full_start_position = k;
                    break;
                }
            } else {
                break;
            }
        }

        k = select_position;
        checkOrder = mInfos.get(k);

        if (checkOrder.getItemType() == 1) {
            select_full_end_position = k;
            k = k + 1;
            if (k < mInfos.size()) {
                checkOrder = mInfos.get(k);
            }
        }

        while (checkOrder.getItemType() != 1) {
//            checkOrder.setSelected(3);
            select_full_end_position = k;
            k = k + 1;
            if (k < mInfos.size()) {
                checkOrder = mInfos.get(k);
            } else {
                break;
            }
        }

        if (resetMultipleSelected()) {
            //再次點擊直接恢復
            notifyDataSetChanged();
            return;
        }

        while (checkOrder.getItemType() != 1) {
            checkOrder.setSelected(3);
            if (k < mInfos.size()) {
                checkOrder = mInfos.get(k);
            } else {
                break;
            }
        }

        k = select_position;
        checkOrder = mInfos.get(k);
        if (checkOrder.getComboLevel() == 2) {
            for (int v = k; v >= 0; v--) {
                if (mInfos.get(v).getItemType() < checkOrder.getItemType()) {
                    mainStartPos = v;
                    break;
                }
            }
        } else {
            if (checkOrder.isIsfood()) {
                checkOrder.setSelected(1);
                mainStartPos = k;
                k = k - 1;
                if (k > -1) {
                    checkOrder = mInfos.get(k);
                }
            }

            while (!checkOrder.isIsfood() && checkOrder.getItemType() <= myorder.getItemType()) {
                if (checkOrder.getItemType() < 3 && checkOrder.getItemType() == myorder.getItemType()) {
                    break;
                }
                checkOrder.setSelected(2);
                k = k - 1;
                if (k > -1) {
                    checkOrder = mInfos.get(k);
                    if (checkOrder.getItemType() < 3 && checkOrder.getItemType() == myorder.getItemType()) {
                        break;
                    }
                    if (checkOrder.isIsfood()) {
                        checkOrder.setSelected(1);
                        mainStartPos = k;
                    }
                } else {
                    break;
                }
            }
        }

        k = select_position;
        checkOrder = mInfos.get(k);
        if (checkOrder.isIsfood() || checkOrder.getProp() == OrderDetail.FOOD_TYPE) {
            mainEndPos = k;
            k = k + 1;
            if (k < mInfos.size()) {
                checkOrder = mInfos.get(k);
            }
        }
        OrderDetail check_Order = checkOrder;
        while (!checkOrder.isIsfood() || check_Order.getComboLevel() == 2) {
            if (check_Order.getComboLevel() == 2) {
                if (checkOrder.getItemType() == 1) {
                    break;
                }
            } else {
                if (checkOrder.getItemType() < 3 && checkOrder.getItemType() == myorder.getItemType()) {
                    break;
                }
            }
            mainEndPos = k;
            k = k + 1;
            if (k < mInfos.size()) {
                checkOrder = mInfos.get(k);
            } else {
                break;
            }
        }

//        if (mMealStandActivity == null || mMealStandActivity.isMultipleSelectionMode()) {
//            for (int v = 0; v < mainStartPos; v++) {
//                if (v < mInfos.size()) {
//                    mInfos.get(v).setSelected(0);
//                }
//            }
//            for (int v = mainEndPos + 1; v < mInfos.size(); v++) {
//                mInfos.get(v).setSelected(0);
//            }
//        } else {
//            for (int v = 0; v < mainStartPos; v++) {
//                if (v < mInfos.size()) {
//                    mInfos.get(v).setSelected(0);
//                }
//            }
//            for (int v = mainEndPos + 1; v < mInfos.size(); v++) {
//                mInfos.get(v).setSelected(0);
//            }
//        }

        if (selectedMode == MULTIPLE_SELECTED) {
            //
        } else {
            //重置未選中的食品狀態（單選）
            for (int v = 0; v < mainStartPos; v++) {
                if (v < mInfos.size()) {
                    mInfos.get(v).setSelected(0);
                }
            }
            for (int v = mainEndPos + 1; v < mInfos.size(); v++) {
                mInfos.get(v).setSelected(0);
            }
        }

        if (mainStartPos >= mInfos.size()) {
            mainStartPos = mInfos.size() - 1;
        }
        OrderDetail order = mInfos.get(mainStartPos);
        if (order.getItemType() != 1) {
            for (int v = mainStartPos; v >= 0; v--) {
                if (mInfos.get(v).getItemType() != 1) {
                    mInfos.get(v).setSelected(1);
                } else {
                    mInfos.get(v).setSelected(1);
                    break;
                }
            }
        }
        for (int v = mainStartPos + 1; v < mInfos.size(); v++) {
            if (mInfos.get(v).getItemType() != 1) {
                mInfos.get(v).setSelected(1);
            } else {
                break;
            }
        }

        for (int v = mainStartPos; v <= mainEndPos; v++) {
            if (v < mInfos.size()) {
                mInfos.get(v).setSelected(1);
            }
        }

        mInfos.get(select_position).setSelected(2);
        if (select_position < mainEndPos) {
            for (int v = select_position + 1; v <= mainEndPos; v++) {
                if (v < mInfos.size()) {
                    if (mInfos.get(v).getItemType() <= mInfos.get(select_position).getItemType()) {
                        break;
                    }
                    if (mInfos.get(v).getItemType() != 3) {
                        break;
                    }
                    if (mInfos.get(v).getItemType() == 3) {
                        mInfos.get(v).setSelected(2);
                    }
                }
            }
        }
        select_start_position = mainStartPos;
        select_end_position = mainEndPos;

        if (mOnItemClickListener != null) {
            mOnItemClickListener.onCurrentOrderDetail(mInfos.get(select_position), select_position);
        }
        notifyDataSetChanged();
    }

    /**
     * 重置已選中食品（多選）
     */
    public boolean resetMultipleSelected() {
        boolean reset = false;
        if (selectedMode == MULTIPLE_SELECTED) {
            for (int i = 0; i < mInfos.size(); i++) {
                OrderDetail datasBean = mInfos.get(i);
                if (select_full_start_position <= i && i <= select_full_end_position && datasBean.getSelected() != 0) {
                    reset = true;
                    datasBean.setSelected(0);
                }
            }
        }
        return reset;
    }

    /**
     * 获取食品子项最后一个子项位置
     *
     * @return
     */
    private int getComboEdgeIndex() {
        int parent_index = getParentFoodIndex(mInfos.get(select_position));
        int edgeIndex = parent_index;
        for (int i = 0; i < mInfos.size(); i++) {
            OrderDetail datasBean = mInfos.get(i);
            if (datasBean.getItemType() == 2 && datasBean.getParentIndex() == parent_index) {
                edgeIndex = i;
            }
        }
        return edgeIndex;
    }

    public boolean canDeleteFood() {
        boolean can = false;
        for (OrderDetail item : mInfos) {
            if (item.getSelected() != 0) {
                can = true;
            }
        }
        if (mInfos.size() == 0 || select_position >= mInfos.size()) {
            can = false;
        }
        return can;
    }

    public boolean canDeleteChildItem() {
        int start_position = select_full_start_position;
        int end_position = select_full_end_position;
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            if (start_position <= i && i <= end_position) {
                if (mInfos.get(i).isNew()) {
                    return true;
                }
            }
        }
        return false;
    }

    public List<OrderDetail> getInfos() {
        return mInfos;
    }

    public int getSelect_position() {
        return select_position;
    }

    public void setSelect_position(int select_position) {
        this.select_position = select_position;
    }

    public void setSelect_end_position(int select_end_position) {
        this.select_end_position = select_end_position;
    }

    public int getSelect_start_position() {
        return select_start_position;
    }

    public int getSelect_end_position() {
        return select_end_position;
    }

    public int getSelect_full_start_position() {
        return select_full_start_position;
    }

    public int getSelect_full_end_position() {
        return select_full_end_position;
    }

    public int getMainStartPos() {
        return mainStartPos;
    }

    public int getMainEndPos() {
        return mainEndPos;
    }

    public int getSelectedMode() {
        return selectedMode;
    }

    public void setSelectedMode(int selectedMode) {
        this.selectedMode = selectedMode;
    }

    public OrderDetail getCurrentOrderDetail() {
        if (select_position != -1 && mInfos.size() > select_position) {
            return mInfos.get(select_position);
        } else {
            return null;
        }
    }

    public OrderDetail getCurrentMainOrderDetail() {
        if (select_full_start_position != -1 && mInfos.size() > select_full_start_position) {
            return mInfos.get(select_full_start_position);
        } else {
            return null;
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(OrderDetail datasBean, int position);

        void onMealCountDelete(OrderDetail datasBean, int position);

        void onMealCountAdd(OrderDetail datasBean, int position);

        void onCurrentOrderDetail(OrderDetail datasBean, int position);
    }

}
