package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodReason;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.FoodReasonAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;
import com.google.android.flexbox.FlexDirection;
import com.google.android.flexbox.FlexWrap;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.google.android.flexbox.JustifyContent;
import com.google.android.material.slider.Slider;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUIEmptyView;
import com.qmuiteam.qmui.widget.QMUISlider;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-28
 * 修订历史：2020-03-28
 * 描述：
 */
public class CancelFoodDialog extends BaseRetryDialog implements Slider.OnSliderTouchListener {

    private static final String TAG = "CancelFoodDialog";

    private Context mContext;

    private int mRadius;
    private float mShadowAlpha = 0.25f;
    private int mShadowElevationDp = 14;

    private int spanCount = 3;
    /***
     * 可取消最大數
     */
    private int mMaxCancelNumber = 10;
    /**
     * 當前選擇的取消數
     */
    private int mCurrCancelNumber = 1;
    /**
     * 取消原因數據
     */
    private List<FoodReason> mItems;
    private FoodReasonAdapter mAdapter;

    private QMUILinearLayout ll_container;
    private QMUITopBar mTopBar;
    private QMUIRoundButton btn_all_number;

    private Slider slider_food_count;
    private TextView tv_number_value, tv_max_number, tv_min_number;

    private QMUIEmptyView mEmptyView;
    private ProgressBar progress;
    private RecyclerView recycle_cancel_info;


    public CancelFoodDialog(@NonNull Context context) {
        super(context, R.style.MyDialogTheme2);
        mContext = context;
        mItems = new ArrayList<>();
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    public void addItems(List<FoodReason> items) {
        if (mItems.size() > 0) {
            mItems.clear();
        }
        mItems.addAll(items);
    }

    public void setMaxCancelNumber(int mMaxCancelNumber) {
        this.mMaxCancelNumber = mMaxCancelNumber;
    }

    public void setCancelNumber(int mCurrCancelNumber) {
        this.mCurrCancelNumber = mCurrCancelNumber;
    }

    public int getCancelNumber() {
        return mCurrCancelNumber;
    }

    public CancelFoodDialog build() {
        View contentView = buildViews();
        int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.6);
        setContentView(contentView, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, screenHeight));

        initParmas();
        return this;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        mTopBar = view.findViewById(R.id.topbar);
        ll_container = view.findViewById(R.id.ll_container);
        tv_number_value = view.findViewById(R.id.tv_number_value);
        btn_all_number = view.findViewById(R.id.btn_all_number);
        slider_food_count = view.findViewById(R.id.slider_food_count);
        tv_max_number = view.findViewById(R.id.tv_max_number);
        tv_min_number = view.findViewById(R.id.tv_min_number);
        mEmptyView = view.findViewById(R.id.emptyView);
        progress = view.findViewById(R.id.progress);
        recycle_cancel_info = view.findViewById(R.id.recycle_cancel_info);

        //設置最大最小取消數
        tv_max_number.setText(String.valueOf(mMaxCancelNumber));
        tv_min_number.setText(String.valueOf(mCurrCancelNumber));

        slider_food_count.addOnSliderTouchListener(this);
        btn_all_number.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                slider_food_count.setValue(mMaxCancelNumber);
            }
        });
        ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        initTopbar();
        initCancelInfoRecycleView();
        return view;
    }

    public void initParmas() {
        mCurrCancelNumber = 1;
        tv_number_value.setText(String.valueOf(mCurrCancelNumber));
        slider_food_count.setValueFrom(mCurrCancelNumber);
        slider_food_count.setValueTo(mMaxCancelNumber);
        slider_food_count.setValue(mCurrCancelNumber);
    }

    private void initTopbar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
        mTopBar.setTitle("取消原因");
    }

    private void initCancelInfoRecycleView() {
        if (mAdapter == null) {
            mAdapter = new FoodReasonAdapter(mItems);
        }
        mAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (onClickListener != null) {
                onClickListener.onItemClick(mItems.get(position), position, getInputNumber());
            }
        });
        recycle_cancel_info.setLayoutManager(createLayoutManager());
        recycle_cancel_info.setAdapter(mAdapter);
    }

    private FlexboxLayoutManager createLayoutManager() {
        FlexboxLayoutManager flexboxLayoutManager = new FlexboxLayoutManager(mContext);
        //flexDirection 属性决定主轴的方向（即项目的排列方向）。类似 LinearLayout 的 vertical 和 horizontal。
        flexboxLayoutManager.setFlexDirection(FlexDirection.ROW);//主轴为水平方向，起点在左端。
        //flexWrap 默认情况下 Flex 跟 LinearLayout 一样，都是不带换行排列的，但是flexWrap属性可以支持换行排列。
        flexboxLayoutManager.setFlexWrap(FlexWrap.WRAP);//按正常方向换行
        //justifyContent 属性定义了项目在主轴上的对齐方式。
        flexboxLayoutManager.setJustifyContent(JustifyContent.FLEX_START);//交叉轴的起点对齐。
        return flexboxLayoutManager;
    }

    public void showEmptyView(boolean isSuccess, int size, Throwable t) {
        showEmptyView(isSuccess, size, t, mEmptyView, recycle_cancel_info);
    }

    public void setProgressVisibility(boolean show) {
        progress.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
    }

    public void notifyDataSetChanged() {
        mEmptyView.hide();
        recycle_cancel_info.setVisibility(View.VISIBLE);
        mAdapter.notifyDataSetChanged();
    }

    private int getInputNumber() {
        return Integer.parseInt(tv_number_value.getText().toString());
    }

    protected int getContentViewLayoutId() {
        return R.layout.table_dialog_cancel_food;
    }

    private OnClickListener onClickListener;

    public void setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    @Override
    public void onStartTrackingTouch(@NonNull Slider slider) {
        mCurrCancelNumber = 1;
        tv_number_value.setText(String.valueOf(slider.getValue()));
    }

    @Override
    public void onStopTrackingTouch(@NonNull Slider slider) {

    }

    public interface OnClickListener {
        void onItemClick(FoodReason item, int position, int deleteNumber);
    }

}
