package com.gingersoft.gsa.cloud.ui.utils;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.TranslateAnimation;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-14
 * 修订历史：2020-05-14
 * 描述：動畫相關工具類
 */
public class AnimateUtils {

    /**
     * 升起动画
     *
     * @param contentView
     * @param duration
     */
    public static void animateUp(View contentView, long duration) {
        if (contentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, 1f, Animation.RELATIVE_TO_SELF, 0f
        );
        AlphaAnimation alpha = new AlphaAnimation(0, 1);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation(translate);
        set.addAnimation(alpha);
        set.setInterpolator(new DecelerateInterpolator());
        set.setDuration(duration);
        set.setFillAfter(true);
        contentView.startAnimation(set);
    }

    /**
     * 降下动画
     *
     * @param contentView
     * @param duration
     */
    public static void animateDown(View contentView, long duration) {
        if (contentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, 0f, Animation.RELATIVE_TO_SELF, 1f
        );
        AlphaAnimation alpha = new AlphaAnimation(1, 0);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation(translate);
        set.addAnimation(alpha);
        set.setInterpolator(new DecelerateInterpolator());
        set.setDuration(duration);
        set.setFillAfter(true);
        contentView.startAnimation(set);
    }

    public static AnimatorSet flashAnimation(View view) {
        return flashAnimation(view, -1, 200);
    }

    /**
     * 閃爍動畫
     *
     * @param view
     */
    public static AnimatorSet flashAnimation(View view, int repeatCount, int duration) {
        view.clearAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(view, "alpha", 0f, 1f);
        ofFloat.setDuration(duration);
        ofFloat.setRepeatCount(repeatCount);
        ofFloat.setRepeatMode(ValueAnimator.REVERSE);

        ObjectAnimator ofFloat1 = ObjectAnimator.ofFloat(view, "alpha", 1f, 0f);
        ofFloat.setDuration(duration);
        ofFloat.setRepeatCount(repeatCount);
        ofFloat.setRepeatMode(ValueAnimator.REVERSE);

        animatorSet.play(ofFloat).with(ofFloat1);
        animatorSet.setDuration(duration * 2);
        animatorSet.start();
        return animatorSet;
    }
}
