package com.joe.print.mvp.model.bean;

import com.joe.print.mvp.print.PrintCleanMachine;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-11-28
 * @update date: 2020-11-28
 * @description:BBPOS打印格式
 */
@Data
public class HtmlLable {

    private String lablename;
    private String value;
    private HtmlLable.Attributes[] attributesList;

    public HtmlLable(String lablename) {
        this.lablename = lablename;
    }

    public HtmlLable(String lablename, String value) {
        this.lablename = lablename;
        this.value = value;
    }

    public HtmlLable(String lablename, String value, HtmlLable.Attributes... attributes) {
        this.lablename = lablename;
        this.value = value;
        this.attributesList = attributes;
    }

    public HtmlLable(String value, HtmlLable.Attributes... attributes) {
        this.value = value;
        this.attributesList = attributes;
    }

    @Data
    public static final class Attributes {
        private String attributesName;
        private String attributesVaule;
        /**
         * 值類型：
         * 0:自身類型 如1=int型
         * 1:字符串 有時間1可能為字符串類型
         */
        private byte valueType = 0;

        public Attributes(String attributesName, String attributesVaule) {
            this.attributesName = attributesName;
            this.attributesVaule = attributesVaule;
        }

        public Attributes(String attributesName, String attributesVaule, byte valueType) {
            this.attributesName = attributesName;
            this.attributesVaule = attributesVaule;
            this.valueType = valueType;
        }
    }

}
