package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 16:42
 * Use:
 */
public class FunctionChildAdapter extends BaseQuickAdapter<Function, BaseViewHolder> {

    public FunctionChildAdapter(@Nullable List<Function> data) {
        super(R.layout.main_function_child_list_item, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, Function function) {
        baseViewHolder.setImageResource(R.id.iv_function_child, function.getIcRes());
        baseViewHolder.setText(R.id.tv_function_child, function.getResName());
    }
}
