package com.gingersoft.gsa.cloud.common.utils;


import java.math.BigDecimal;

import static java.math.BigDecimal.ROUND_HALF_UP;

/**
 * Created by Administrator on 2018/9/10 0010.
 */

public class MoneyUtil {

    // 總金額小數位
    public static Integer rounding = 0, RoundingDecimal = 1;
    // (直接截取) :  食品   細項   折扣  會員折扣  合計  服務費
    public static Integer ItemDecimals = 2;

    public static double get_ItemDecimals_money(double money) {
        double rMoney = money;
        //返回指定的小数位：
        //e.g Coke $13.456
        //ItemDecimals=0 $13.00
        //ItemDecimals=1 $13.40
        //ItemDecimals=2 $13.45
        rMoney = BigDecimal.valueOf(money).setScale(ItemDecimals, BigDecimal.ROUND_DOWN).doubleValue();
        return rMoney;
    }

    public static double getOrderRounding(double vprice) {

        int vNum = 0, x, y;
        double xvPrice = vprice;
        double Result = vprice;

        if (RoundingDecimal > 0) {
            vNum = (int) (Math.floor(vprice * (Math.pow(10, RoundingDecimal))) - Math.floor(vprice * (Math.pow(10, RoundingDecimal)) / 10) * 10);
        } else if (RoundingDecimal < 0) {
            x = (int) Math.floor(vprice * (Math.pow(10, RoundingDecimal)) * 10);
            y = (int) Math.floor(vprice * (Math.pow(10, RoundingDecimal)) * 10);
            vNum = x - y;
        }

//        //帐单小数
//        //Sys_AndroidSetting \Rounding 帳單小數算法
//        //例如: e.g
//        //Rounding=0  0.1-0.9=0.0 /
//        //Rounding=1  0.1-0.9=1.0 /
//        //Rounding=2  0.1-0.4=0.0 and 0.5-0.9=1.0  即 4 捨 5 入
//        //Rounding=3  0.1-0.5=0.5 and 0.6-0.9=1.0
//
//        //Sys_AndroidSetting \RoundingDecimal 整單的小數位
//        //例如:帳單總金額 13.456
//        //RoundingDecimal=1   小數後1個位進行四捨五入, 總金額結果= 13.00
//        //RoundingDecimal=2   小數後2個位進行四捨五入, 總金額結果= 13.50
//
//        //12.25                                                RoundingDecimal=1    	RoundingDecimal=2
//        //Rounding=0(0.1-0.9=0.0)	                                     12.00          	   12.20
//        //Rounding=1(0.1-0.9=1.0)      	                             13.00	               12.30
//        //Rounding=2(0.1-0.4=0.0 and 0.5-0.9=1.0)                  	 12.00				   12.30
//        //Rounding=3(0.1-0.5=0.5 and 0.6-0.9=1.0)	                     12.50                 12.25

        switch (rounding) {
            case 0:
                if (RoundingDecimal == 1) {
                    xvPrice = Math.floor(vprice);
                } else if (RoundingDecimal > 0) {
                    xvPrice = Math.floor(vprice * (Math.pow(10, RoundingDecimal - 1))) / (Math.pow(10, RoundingDecimal - 1));
                } else {
                    xvPrice = Math.floor(vprice * (Math.pow(10, RoundingDecimal))) / (Math.pow(10, RoundingDecimal));
                }
                break;
            case 1:
                if (RoundingDecimal == 1) {
                    if (vNum > 0) {
                        xvPrice = Math.floor(vprice) + 1;
                    } else {
                        xvPrice = Math.floor(vprice);
                    }
                } else {
                    if (vNum > 0) {
                        if (RoundingDecimal > 0) {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal - 1))) + 1) / (Math.pow(10, RoundingDecimal - 1));
                        } else {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal))) + 1) / (Math.pow(10, RoundingDecimal));
                        }
                    } else {
                        xvPrice = Math.floor(vprice * (Math.pow(10, RoundingDecimal))) / (Math.pow(10, RoundingDecimal));
                    }
                }
                break;
            case 2:
                if (RoundingDecimal == 1) {
                    if (vNum > 4) {
                        xvPrice = Math.floor(vprice) + 1;
                    } else {
                        xvPrice = Math.floor(vprice);
                    }
                } else {
                    if (vNum > 4) {
                        if (RoundingDecimal > 0) {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal - 1))) + 1) / (Math.pow(10, RoundingDecimal - 1));
                        } else {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal))) + 1) / (Math.pow(10, RoundingDecimal));
                        }
                    } else {
                        if (RoundingDecimal > 0) {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal - 1)))) / (Math.pow(10, RoundingDecimal - 1));
                        } else {
                            xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal)))) / (Math.pow(10, RoundingDecimal));
                        }
                    }
                }
                break;
            case 3:
                if (vNum > 5) {
                    if (RoundingDecimal == 1) {
                        xvPrice = Math.floor(vprice) + 1;
                    } else if (RoundingDecimal > 0) {
                        xvPrice = Math.floor(vprice * (Math.pow(10, (RoundingDecimal - 1))) + 1) / (Math.pow(10, RoundingDecimal - 1));
                    } else {
                        xvPrice = Math.floor(vprice * (Math.pow(10, (RoundingDecimal))) + 1) / (Math.pow(10, RoundingDecimal));
                    }
                } else {
                    if (RoundingDecimal == 1) {
                        if (vNum == 0) {
                            xvPrice = Math.floor(vprice);
                        } else {
                            xvPrice = (Math.floor(vprice) * 10 + 5) / 10;
                        }
                    } else if (RoundingDecimal > 0) {
                        xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal - 1))) * 10 + 5) / (Math.pow(10, RoundingDecimal));
                    } else {
                        xvPrice = (Math.floor(vprice * (Math.pow(10, RoundingDecimal))) * 10 + 5) / (Math.pow(10, RoundingDecimal + 1));
                    }
                }
                break;
            default:
                break;
        }
        Result = getDecimalMoney(xvPrice, 2);
        return Result;
    }

    public static double getDecimalMoney(double money, int decimal) {
        return BigDecimal.valueOf(money).setScale(decimal, ROUND_HALF_UP).doubleValue();
    }

    /**
     * 计算总价
     * 乘
     *
     * @param price
     * @param number
     * @return
     */
    public static double priceCalculation(double price, int number) {
        BigDecimal b1 = BigDecimal.valueOf(price);
        BigDecimal b2 = BigDecimal.valueOf(number);
        return (b1.multiply(b2)).setScale(1, ROUND_HALF_UP).doubleValue();
    }

    /**
     * 计算总价
     * 乘
     *
     * @param price
     * @param number
     * @return
     */
    public static double priceCalculation(double price, double number) {
        BigDecimal b1 = BigDecimal.valueOf(price);
        BigDecimal b2 = BigDecimal.valueOf(number);
        return (b1.multiply(b2)).setScale(1, ROUND_HALF_UP).doubleValue();
    }

    /**
     * 计算总价
     * 計算和
     *
     * @param price
     * @param number
     * @return
     */
    public static double sum(double price, double number) {
        BigDecimal b1 = BigDecimal.valueOf(price);
        BigDecimal b2 = BigDecimal.valueOf(number);
        return b1.add(b2).doubleValue();
    }

    /**
     * 计算总价
     * 計算和
     *
     * @param price
     * @param price2
     * @return
     */
    public static BigDecimal sum(BigDecimal price, double price2) {
        BigDecimal b2 = BigDecimal.valueOf(price2);
        return price.add(b2);
    }

    /**
     * 計算差
     *
     * @param v1
     * @param v2
     * @return
     */
    public static double sub(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).doubleValue();
    }


    /**
     * 計算差
     *
     * @param v1
     * @param v2
     * @return
     */
    public static double sub(double v1, double... v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        for (int i = 0; i < v2.length; i++) {
            BigDecimal b2 = BigDecimal.valueOf(v2[i]);
            b1 = b1.subtract(b2);
        }
        return b1.doubleValue();
    }

    /**
     * 計算差
     *
     * @param v1
     * @param v2
     * @return
     */
//    public static double sub(String v1, double v2) {
//        BigDecimal b1 = BigDecimal.valueOf(v1);
//        BigDecimal b2 = BigDecimal.valueOf(v2);
//        return b1.subtract(b2).doubleValue();
//    }

    /**
     * BigDecimal 相乘
     *
     * @param v1
     * @param v2
     * @return double
     */
    public static Double multiply(double v1, double v2) {
        BigDecimal n1 = BigDecimal.valueOf(v1);
        BigDecimal n2 = BigDecimal.valueOf(v2);
        return n1.multiply(n2).doubleValue();
    }

    /**
     * 計算除 保留兩位小數，四捨五入
     *
     * @param v1
     * @param v2
     * @return
     */
    public static BigDecimal divide(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        if (b2.intValue() <= 0) {
            return b2;
        }
        return b1.divide(b2, 2, ROUND_HALF_UP);
    }

    /**
     * 計算除
     *
     * @param v1
     * @param v2
     * @param scale        保留幾位小數
     * @param RoundingMode ROUND_HALF_UP為四捨五入
     * @return
     */
    public static float divide(double v1, double v2, int scale, int RoundingMode) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        if (b2.intValue() <= 0) {
            return 0f;
        }
        return b1.divide(b2, scale, RoundingMode).floatValue();
    }

    /**
     * 計算除
     *
     * @param v1
     * @param v2
     * @param scale 保留幾位小數
     * @return
     */
    public static float divide(double v1, double v2, int scale) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        if (b2.intValue() <= 0) {
            return 0f;
        }
        return b1.divide(b2, scale, ROUND_HALF_UP).floatValue();
    }

    /**
     * 計算差
     *
     * @param v1
     * @param v2
     * @return
     */
    public static int sub(int v1, int v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).intValue();
    }

    /**
     * 食品总价保留两位
     *
     * @param totalPrice
     * @return
     */
    public static double totalFoodPrice(double totalPrice) {
        BigDecimal b = BigDecimal.valueOf(totalPrice);
        return b.setScale(1, ROUND_HALF_UP).doubleValue();
    }

    /**
     * 將兩個double值進行比較
     * 小於0
     *
     * @return {@code 1} if {@code this > val}, {@code -1} if {@code this < val},
     * {@code 0} if {@code this == val}.
     */
    public static int compareTo(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.compareTo(b2);
    }

    /**
     * 如果double小數為0，則不顯示小數位
     */
    public static String formatDouble(double d) {
        int tran = (int) d;
        if (tran == d) {
            return String.valueOf(tran);
        } else {
            return String.valueOf(d);
        }
    }
}
