package com.gingersoft.gsa.cloud.main;

import android.content.Intent;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.IComponent;
import com.gingersoft.gsa.cloud.function.FModule;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.NewMainActivity;

public class ComponentMain implements IComponent {

    public static final class main {
        /**
         * 首頁- 點餐
         */
        public static final FModule[] order = {
                new FModule("main/order", 0, 0),
                new FModule("main/order/table", R.drawable.ic_dining_table_mode, R.drawable.ic_dining_table_mode_close),
                new FModule("main/order/delivery", R.drawable.ic_delivery_mode, R.drawable.ic_delivery_mode_close),
                new FModule("main/order/takeaway", R.drawable.ic_outsourcing_model, R.drawable.ic_outsourcing_model_close),
                new FModule("main/order/preorder", R.drawable.ic_pre_order_mode, R.drawable.ic_pre_order_mode_close),
                new FModule("main/order/coldChain", R.drawable.ic_cold_chain, R.drawable.ic_pre_order_mode_close),
        };
        /**
         * 首頁- 管理
         */
        public static final FModule[] manager = {
                new FModule("main/manager", 0, 0),
                new FModule("main/manager/takeaway", R.drawable.ic_meals_menu_management, R.drawable.ic_meals_menu_management_close),
                new FModule("main/manager/bill", R.drawable.ic_meals_menu_management, R.drawable.ic_meals_menu_management_close),
                new FModule("main/manager/table", R.drawable.ic_dining_table_management, R.drawable.ic_dining_table_management_close),
                new FModule("main/manager/printer", R.drawable.ic_print_management, R.drawable.ic_print_management_close),
                new FModule("main/manager/pay", R.drawable.ic_pay_management, R.drawable.ic_pay_management_close),
                new FModule("main/manager/discout", R.drawable.ic_discount_management, R.drawable.ic_discount_management_close),
                new FModule("main/manager/soldoutCtr", R.drawable.ic_sell_off_manger, R.drawable.ic_sell_off_manger),
                new FModule("main/manager/qrCode", R.drawable.ic_discount_management, R.drawable.ic_discount_management_close)
        };
        /**
         * 首頁- 員工管理
         */
        public static final FModule[] employee = {
                new FModule("main/employee", 0, 0),
                new FModule("main/employee/management", R.drawable.ic_staff_management, R.drawable.ic_staff_management_close),
                new FModule("main/employee/delivery", R.drawable.ic_authority_management, R.drawable.ic_authority_management_close),
                new FModule("main/employee/operationRecord", R.drawable.ic_operation_record, R.drawable.ic_operation_record_close)
        };
    }

    @Override
    public String getName() {
        //组件的名称，调用此组件的方式：
        // CC.obtainBuilder("ComponentA")...build().callAsync()
        return "Component.Main";
    }

    /**
     * 组件被调用时的入口
     * 要确保每个逻辑分支都会调用到CC.sendCCResult，
     * 包括try-catch,if-else,switch-case-default,startActivity
     *
     * @param cc 组件调用对象，可从此对象中获取相关信息
     * @return true:将异步调用CC.sendCCResult(...),用于异步实现相关功能，例如：文件加载、网络请求等
     * false:会同步调用CC.sendCCResult(...),即在onCall方法return之前调用，否则将被视为不合法的实现
     */
    @Override
    public boolean onCall(CC cc) {
        String actionName = cc.getActionName();
        switch (actionName) {
            case "showMainActivity":
                openActivity(cc);
                break;
            case "getLifecycleFragment":
                //demo for provide fragment object to other component
                getLifecycleFragment(cc);
                break;
            case "lifecycleFragment.addText":
                lifecycleFragmentDoubleText(cc);
                break;
            case "getInfo":
                getInfo(cc);
                break;
            default:
                //这个逻辑分支上没有调用CC.sendCCResult(...),是一种错误的示例
                //并且方法的返回值为false，代表不会异步调用CC.sendCCResult(...)
                //在LocalCCInterceptor中将会返回错误码为-10的CCResult
                break;
        }
        return false;
    }

    private void lifecycleFragmentDoubleText(CC cc) {
//        LifecycleFragment lifecycleFragment = cc.getParamItem("fragment");
//        if (lifecycleFragment != null) {
//            String text = cc.getParamItem("text", "");
//            lifecycleFragment.addText(text);
//            CC.sendCCResult(cc.getCallId(), CCResult.success());
//        } else {
//            CC.sendCCResult(cc.getCallId(), CCResult.error("no fragment params"));
//        }
    }

    private void getLifecycleFragment(CC cc) {
//        CC.sendCCResult(cc.getCallId(), CCResult.successWithNoKey(new LifecycleFragment()));
    }

    private void getInfo(CC cc) {
        String userName = "billy";
        CC.sendCCResult(cc.getCallId(), CCResult.success("userName", userName));
    }

    private void openActivity(CC cc) {
        Intent intent = new Intent(cc.getContext(), NewMainActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        cc.getContext().startActivity(intent);
//        CCUtil.createNavigateIntent(cc, MainActivity.class);
//        CC.sendCCResult(cc.getCallId(), CCResult.success());
    }

}
